package me.snowdrop.istio.api.mesh.v1alpha1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.lang.String;
import com.fasterxml.jackson.databind.JsonDeserializer;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Boolean;
import java.lang.Override;
import me.snowdrop.istio.api.Duration;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import me.snowdrop.istio.api.DurationBuilder;
import me.snowdrop.istio.api.DurationFluentImpl;
import me.snowdrop.istio.api.Int32ValueBuilder;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import com.fasterxml.jackson.databind.JsonSerializer;
import java.lang.Deprecated;
import me.snowdrop.istio.api.Int32Value;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.core.JsonParser;
import java.lang.Integer;
import java.lang.StringBuffer;
import me.snowdrop.istio.api.Int32ValueFluentImpl;

public class ProxyConfigFluentImpl<A extends ProxyConfigFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ProxyConfigFluent<A>{

    private String availabilityZone;
    private String binaryPath;
    private Int32ValueBuilder concurrency;
    private String configPath;
    private AuthenticationPolicy controlPlaneAuthPolicy;
    private String customConfigFile;
    private String discoveryAddress;
    private DurationBuilder discoveryRefreshDelay;
    private DurationBuilder drainDuration;
    private RemoteServiceBuilder envoyAccessLogService;
    private RemoteServiceBuilder envoyMetricsService;
    private String envoyMetricsServiceAddress;
    private List<String> extraStatTags;
    private TopologyBuilder gatewayTopology;
    private InboundInterceptionMode interceptionMode;
    private String meshId;
    private DurationBuilder parentShutdownDuration;
    private Integer proxyAdminPort;
    private String proxyBootstrapTemplatePath;
    private Map<String,String> proxyMetadata;
    private SDSBuilder sds;
    private String serviceCluster;
    private Integer statNameLength;
    private String statsdUdpAddress;
    private Integer statusPort;
    private DurationBuilder terminationDrainDuration;
    private TracingBuilder tracing;
    private String zipkinAddress;

    public ProxyConfigFluentImpl(){
    }
    public ProxyConfigFluentImpl(ProxyConfig instance){
            this.withAvailabilityZone(instance.getAvailabilityZone()); 
            this.withBinaryPath(instance.getBinaryPath()); 
            this.withConcurrency(instance.getConcurrency()); 
            this.withConfigPath(instance.getConfigPath()); 
            this.withControlPlaneAuthPolicy(instance.getControlPlaneAuthPolicy()); 
            this.withCustomConfigFile(instance.getCustomConfigFile()); 
            this.withDiscoveryAddress(instance.getDiscoveryAddress()); 
            this.withDiscoveryRefreshDelay(instance.getDiscoveryRefreshDelay()); 
            this.withDrainDuration(instance.getDrainDuration()); 
            this.withEnvoyAccessLogService(instance.getEnvoyAccessLogService()); 
            this.withEnvoyMetricsService(instance.getEnvoyMetricsService()); 
            this.withEnvoyMetricsServiceAddress(instance.getEnvoyMetricsServiceAddress()); 
            this.withExtraStatTags(instance.getExtraStatTags()); 
            this.withGatewayTopology(instance.getGatewayTopology()); 
            this.withInterceptionMode(instance.getInterceptionMode()); 
            this.withMeshId(instance.getMeshId()); 
            this.withParentShutdownDuration(instance.getParentShutdownDuration()); 
            this.withProxyAdminPort(instance.getProxyAdminPort()); 
            this.withProxyBootstrapTemplatePath(instance.getProxyBootstrapTemplatePath()); 
            this.withProxyMetadata(instance.getProxyMetadata()); 
            this.withSds(instance.getSds()); 
            this.withServiceCluster(instance.getServiceCluster()); 
            this.withStatNameLength(instance.getStatNameLength()); 
            this.withStatsdUdpAddress(instance.getStatsdUdpAddress()); 
            this.withStatusPort(instance.getStatusPort()); 
            this.withTerminationDrainDuration(instance.getTerminationDrainDuration()); 
            this.withTracing(instance.getTracing()); 
            this.withZipkinAddress(instance.getZipkinAddress()); 
    }

    public String getAvailabilityZone(){
            return this.availabilityZone;
    }

    public A withAvailabilityZone(String availabilityZone){
            this.availabilityZone=availabilityZone; return (A) this;
    }

    public Boolean hasAvailabilityZone(){
            return this.availabilityZone != null;
    }

    public A withNewAvailabilityZone(String arg1){
            return (A)withAvailabilityZone(new String(arg1));
    }

    public A withNewAvailabilityZone(StringBuilder arg1){
            return (A)withAvailabilityZone(new String(arg1));
    }

    public A withNewAvailabilityZone(StringBuffer arg1){
            return (A)withAvailabilityZone(new String(arg1));
    }

    public String getBinaryPath(){
            return this.binaryPath;
    }

    public A withBinaryPath(String binaryPath){
            this.binaryPath=binaryPath; return (A) this;
    }

    public Boolean hasBinaryPath(){
            return this.binaryPath != null;
    }

    public A withNewBinaryPath(String arg1){
            return (A)withBinaryPath(new String(arg1));
    }

    public A withNewBinaryPath(StringBuilder arg1){
            return (A)withBinaryPath(new String(arg1));
    }

    public A withNewBinaryPath(StringBuffer arg1){
            return (A)withBinaryPath(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildConcurrency instead.
 * @return The buildable object.
 */
@Deprecated public Int32Value getConcurrency(){
            return this.concurrency!=null?this.concurrency.build():null;
    }

    public Int32Value buildConcurrency(){
            return this.concurrency!=null?this.concurrency.build():null;
    }

    public A withConcurrency(Int32Value concurrency){
            _visitables.get("concurrency").remove(this.concurrency);
            if (concurrency!=null){ this.concurrency= new Int32ValueBuilder(concurrency); _visitables.get("concurrency").add(this.concurrency);} return (A) this;
    }

    public Boolean hasConcurrency(){
            return this.concurrency != null;
    }

    public A withNewConcurrency(Integer value){
            return (A)withConcurrency(new Int32Value(value));
    }

    public ProxyConfigFluent.ConcurrencyNested<A> withNewConcurrency(){
            return new ConcurrencyNestedImpl();
    }

    public ProxyConfigFluent.ConcurrencyNested<A> withNewConcurrencyLike(Int32Value item){
            return new ConcurrencyNestedImpl(item);
    }

    public ProxyConfigFluent.ConcurrencyNested<A> editConcurrency(){
            return withNewConcurrencyLike(getConcurrency());
    }

    public ProxyConfigFluent.ConcurrencyNested<A> editOrNewConcurrency(){
            return withNewConcurrencyLike(getConcurrency() != null ? getConcurrency(): new Int32ValueBuilder().build());
    }

    public ProxyConfigFluent.ConcurrencyNested<A> editOrNewConcurrencyLike(Int32Value item){
            return withNewConcurrencyLike(getConcurrency() != null ? getConcurrency(): item);
    }

    public String getConfigPath(){
            return this.configPath;
    }

    public A withConfigPath(String configPath){
            this.configPath=configPath; return (A) this;
    }

    public Boolean hasConfigPath(){
            return this.configPath != null;
    }

    public A withNewConfigPath(String arg1){
            return (A)withConfigPath(new String(arg1));
    }

    public A withNewConfigPath(StringBuilder arg1){
            return (A)withConfigPath(new String(arg1));
    }

    public A withNewConfigPath(StringBuffer arg1){
            return (A)withConfigPath(new String(arg1));
    }

    public AuthenticationPolicy getControlPlaneAuthPolicy(){
            return this.controlPlaneAuthPolicy;
    }

    public A withControlPlaneAuthPolicy(AuthenticationPolicy controlPlaneAuthPolicy){
            this.controlPlaneAuthPolicy=controlPlaneAuthPolicy; return (A) this;
    }

    public Boolean hasControlPlaneAuthPolicy(){
            return this.controlPlaneAuthPolicy != null;
    }

    public String getCustomConfigFile(){
            return this.customConfigFile;
    }

    public A withCustomConfigFile(String customConfigFile){
            this.customConfigFile=customConfigFile; return (A) this;
    }

    public Boolean hasCustomConfigFile(){
            return this.customConfigFile != null;
    }

    public A withNewCustomConfigFile(String arg1){
            return (A)withCustomConfigFile(new String(arg1));
    }

    public A withNewCustomConfigFile(StringBuilder arg1){
            return (A)withCustomConfigFile(new String(arg1));
    }

    public A withNewCustomConfigFile(StringBuffer arg1){
            return (A)withCustomConfigFile(new String(arg1));
    }

    public String getDiscoveryAddress(){
            return this.discoveryAddress;
    }

    public A withDiscoveryAddress(String discoveryAddress){
            this.discoveryAddress=discoveryAddress; return (A) this;
    }

    public Boolean hasDiscoveryAddress(){
            return this.discoveryAddress != null;
    }

    public A withNewDiscoveryAddress(String arg1){
            return (A)withDiscoveryAddress(new String(arg1));
    }

    public A withNewDiscoveryAddress(StringBuilder arg1){
            return (A)withDiscoveryAddress(new String(arg1));
    }

    public A withNewDiscoveryAddress(StringBuffer arg1){
            return (A)withDiscoveryAddress(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildDiscoveryRefreshDelay instead.
 * @return The buildable object.
 */
@Deprecated public Duration getDiscoveryRefreshDelay(){
            return this.discoveryRefreshDelay!=null?this.discoveryRefreshDelay.build():null;
    }

    public Duration buildDiscoveryRefreshDelay(){
            return this.discoveryRefreshDelay!=null?this.discoveryRefreshDelay.build():null;
    }

    public A withDiscoveryRefreshDelay(Duration discoveryRefreshDelay){
            _visitables.get("discoveryRefreshDelay").remove(this.discoveryRefreshDelay);
            if (discoveryRefreshDelay!=null){ this.discoveryRefreshDelay= new DurationBuilder(discoveryRefreshDelay); _visitables.get("discoveryRefreshDelay").add(this.discoveryRefreshDelay);} return (A) this;
    }

    public Boolean hasDiscoveryRefreshDelay(){
            return this.discoveryRefreshDelay != null;
    }

    public A withNewDiscoveryRefreshDelay(Integer nanos,Long seconds){
            return (A)withDiscoveryRefreshDelay(new Duration(nanos, seconds));
    }

    public ProxyConfigFluent.DiscoveryRefreshDelayNested<A> withNewDiscoveryRefreshDelay(){
            return new DiscoveryRefreshDelayNestedImpl();
    }

    public ProxyConfigFluent.DiscoveryRefreshDelayNested<A> withNewDiscoveryRefreshDelayLike(Duration item){
            return new DiscoveryRefreshDelayNestedImpl(item);
    }

    public ProxyConfigFluent.DiscoveryRefreshDelayNested<A> editDiscoveryRefreshDelay(){
            return withNewDiscoveryRefreshDelayLike(getDiscoveryRefreshDelay());
    }

    public ProxyConfigFluent.DiscoveryRefreshDelayNested<A> editOrNewDiscoveryRefreshDelay(){
            return withNewDiscoveryRefreshDelayLike(getDiscoveryRefreshDelay() != null ? getDiscoveryRefreshDelay(): new DurationBuilder().build());
    }

    public ProxyConfigFluent.DiscoveryRefreshDelayNested<A> editOrNewDiscoveryRefreshDelayLike(Duration item){
            return withNewDiscoveryRefreshDelayLike(getDiscoveryRefreshDelay() != null ? getDiscoveryRefreshDelay(): item);
    }

    
/**
 * This method has been deprecated, please use method buildDrainDuration instead.
 * @return The buildable object.
 */
@Deprecated public Duration getDrainDuration(){
            return this.drainDuration!=null?this.drainDuration.build():null;
    }

    public Duration buildDrainDuration(){
            return this.drainDuration!=null?this.drainDuration.build():null;
    }

    public A withDrainDuration(Duration drainDuration){
            _visitables.get("drainDuration").remove(this.drainDuration);
            if (drainDuration!=null){ this.drainDuration= new DurationBuilder(drainDuration); _visitables.get("drainDuration").add(this.drainDuration);} return (A) this;
    }

    public Boolean hasDrainDuration(){
            return this.drainDuration != null;
    }

    public A withNewDrainDuration(Integer nanos,Long seconds){
            return (A)withDrainDuration(new Duration(nanos, seconds));
    }

    public ProxyConfigFluent.DrainDurationNested<A> withNewDrainDuration(){
            return new DrainDurationNestedImpl();
    }

    public ProxyConfigFluent.DrainDurationNested<A> withNewDrainDurationLike(Duration item){
            return new DrainDurationNestedImpl(item);
    }

    public ProxyConfigFluent.DrainDurationNested<A> editDrainDuration(){
            return withNewDrainDurationLike(getDrainDuration());
    }

    public ProxyConfigFluent.DrainDurationNested<A> editOrNewDrainDuration(){
            return withNewDrainDurationLike(getDrainDuration() != null ? getDrainDuration(): new DurationBuilder().build());
    }

    public ProxyConfigFluent.DrainDurationNested<A> editOrNewDrainDurationLike(Duration item){
            return withNewDrainDurationLike(getDrainDuration() != null ? getDrainDuration(): item);
    }

    
/**
 * This method has been deprecated, please use method buildEnvoyAccessLogService instead.
 * @return The buildable object.
 */
@Deprecated public RemoteService getEnvoyAccessLogService(){
            return this.envoyAccessLogService!=null?this.envoyAccessLogService.build():null;
    }

    public RemoteService buildEnvoyAccessLogService(){
            return this.envoyAccessLogService!=null?this.envoyAccessLogService.build():null;
    }

    public A withEnvoyAccessLogService(RemoteService envoyAccessLogService){
            _visitables.get("envoyAccessLogService").remove(this.envoyAccessLogService);
            if (envoyAccessLogService!=null){ this.envoyAccessLogService= new RemoteServiceBuilder(envoyAccessLogService); _visitables.get("envoyAccessLogService").add(this.envoyAccessLogService);} return (A) this;
    }

    public Boolean hasEnvoyAccessLogService(){
            return this.envoyAccessLogService != null;
    }

    public ProxyConfigFluent.EnvoyAccessLogServiceNested<A> withNewEnvoyAccessLogService(){
            return new EnvoyAccessLogServiceNestedImpl();
    }

    public ProxyConfigFluent.EnvoyAccessLogServiceNested<A> withNewEnvoyAccessLogServiceLike(RemoteService item){
            return new EnvoyAccessLogServiceNestedImpl(item);
    }

    public ProxyConfigFluent.EnvoyAccessLogServiceNested<A> editEnvoyAccessLogService(){
            return withNewEnvoyAccessLogServiceLike(getEnvoyAccessLogService());
    }

    public ProxyConfigFluent.EnvoyAccessLogServiceNested<A> editOrNewEnvoyAccessLogService(){
            return withNewEnvoyAccessLogServiceLike(getEnvoyAccessLogService() != null ? getEnvoyAccessLogService(): new RemoteServiceBuilder().build());
    }

    public ProxyConfigFluent.EnvoyAccessLogServiceNested<A> editOrNewEnvoyAccessLogServiceLike(RemoteService item){
            return withNewEnvoyAccessLogServiceLike(getEnvoyAccessLogService() != null ? getEnvoyAccessLogService(): item);
    }

    
/**
 * This method has been deprecated, please use method buildEnvoyMetricsService instead.
 * @return The buildable object.
 */
@Deprecated public RemoteService getEnvoyMetricsService(){
            return this.envoyMetricsService!=null?this.envoyMetricsService.build():null;
    }

    public RemoteService buildEnvoyMetricsService(){
            return this.envoyMetricsService!=null?this.envoyMetricsService.build():null;
    }

    public A withEnvoyMetricsService(RemoteService envoyMetricsService){
            _visitables.get("envoyMetricsService").remove(this.envoyMetricsService);
            if (envoyMetricsService!=null){ this.envoyMetricsService= new RemoteServiceBuilder(envoyMetricsService); _visitables.get("envoyMetricsService").add(this.envoyMetricsService);} return (A) this;
    }

    public Boolean hasEnvoyMetricsService(){
            return this.envoyMetricsService != null;
    }

    public ProxyConfigFluent.EnvoyMetricsServiceNested<A> withNewEnvoyMetricsService(){
            return new EnvoyMetricsServiceNestedImpl();
    }

    public ProxyConfigFluent.EnvoyMetricsServiceNested<A> withNewEnvoyMetricsServiceLike(RemoteService item){
            return new EnvoyMetricsServiceNestedImpl(item);
    }

    public ProxyConfigFluent.EnvoyMetricsServiceNested<A> editEnvoyMetricsService(){
            return withNewEnvoyMetricsServiceLike(getEnvoyMetricsService());
    }

    public ProxyConfigFluent.EnvoyMetricsServiceNested<A> editOrNewEnvoyMetricsService(){
            return withNewEnvoyMetricsServiceLike(getEnvoyMetricsService() != null ? getEnvoyMetricsService(): new RemoteServiceBuilder().build());
    }

    public ProxyConfigFluent.EnvoyMetricsServiceNested<A> editOrNewEnvoyMetricsServiceLike(RemoteService item){
            return withNewEnvoyMetricsServiceLike(getEnvoyMetricsService() != null ? getEnvoyMetricsService(): item);
    }

    public String getEnvoyMetricsServiceAddress(){
            return this.envoyMetricsServiceAddress;
    }

    public A withEnvoyMetricsServiceAddress(String envoyMetricsServiceAddress){
            this.envoyMetricsServiceAddress=envoyMetricsServiceAddress; return (A) this;
    }

    public Boolean hasEnvoyMetricsServiceAddress(){
            return this.envoyMetricsServiceAddress != null;
    }

    public A withNewEnvoyMetricsServiceAddress(String arg1){
            return (A)withEnvoyMetricsServiceAddress(new String(arg1));
    }

    public A withNewEnvoyMetricsServiceAddress(StringBuilder arg1){
            return (A)withEnvoyMetricsServiceAddress(new String(arg1));
    }

    public A withNewEnvoyMetricsServiceAddress(StringBuffer arg1){
            return (A)withEnvoyMetricsServiceAddress(new String(arg1));
    }

    public A addToExtraStatTags(int index,String item){
            if (this.extraStatTags == null) {this.extraStatTags = new ArrayList<String>();}
            this.extraStatTags.add(index, item);
            return (A)this;
    }

    public A setToExtraStatTags(int index,String item){
            if (this.extraStatTags == null) {this.extraStatTags = new ArrayList<String>();}
            this.extraStatTags.set(index, item); return (A)this;
    }

    public A addToExtraStatTags(String... items){
            if (this.extraStatTags == null) {this.extraStatTags = new ArrayList<String>();}
            for (String item : items) {this.extraStatTags.add(item);} return (A)this;
    }

    public A addAllToExtraStatTags(Collection<String> items){
            if (this.extraStatTags == null) {this.extraStatTags = new ArrayList<String>();}
            for (String item : items) {this.extraStatTags.add(item);} return (A)this;
    }

    public A removeFromExtraStatTags(String... items){
            for (String item : items) {if (this.extraStatTags!= null){ this.extraStatTags.remove(item);}} return (A)this;
    }

    public A removeAllFromExtraStatTags(Collection<String> items){
            for (String item : items) {if (this.extraStatTags!= null){ this.extraStatTags.remove(item);}} return (A)this;
    }

    public List<String> getExtraStatTags(){
            return this.extraStatTags;
    }

    public String getExtraStatTag(int index){
            return this.extraStatTags.get(index);
    }

    public String getFirstExtraStatTag(){
            return this.extraStatTags.get(0);
    }

    public String getLastExtraStatTag(){
            return this.extraStatTags.get(extraStatTags.size() - 1);
    }

    public String getMatchingExtraStatTag(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: extraStatTags) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingExtraStatTag(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: extraStatTags) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withExtraStatTags(List<String> extraStatTags){
            if (this.extraStatTags != null) { _visitables.get("extraStatTags").removeAll(this.extraStatTags);}
            if (extraStatTags != null) {this.extraStatTags = new ArrayList<String>(); for (String item : extraStatTags){this.addToExtraStatTags(item);}} else { this.extraStatTags = null;} return (A) this;
    }

    public A withExtraStatTags(String... extraStatTags){
            if (this.extraStatTags != null) {this.extraStatTags.clear();}
            if (extraStatTags != null) {for (String item :extraStatTags){ this.addToExtraStatTags(item);}} return (A) this;
    }

    public Boolean hasExtraStatTags(){
            return extraStatTags != null && !extraStatTags.isEmpty();
    }

    public A addNewExtraStatTag(String arg1){
            return (A)addToExtraStatTags(new String(arg1));
    }

    public A addNewExtraStatTag(StringBuilder arg1){
            return (A)addToExtraStatTags(new String(arg1));
    }

    public A addNewExtraStatTag(StringBuffer arg1){
            return (A)addToExtraStatTags(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildGatewayTopology instead.
 * @return The buildable object.
 */
@Deprecated public Topology getGatewayTopology(){
            return this.gatewayTopology!=null?this.gatewayTopology.build():null;
    }

    public Topology buildGatewayTopology(){
            return this.gatewayTopology!=null?this.gatewayTopology.build():null;
    }

    public A withGatewayTopology(Topology gatewayTopology){
            _visitables.get("gatewayTopology").remove(this.gatewayTopology);
            if (gatewayTopology!=null){ this.gatewayTopology= new TopologyBuilder(gatewayTopology); _visitables.get("gatewayTopology").add(this.gatewayTopology);} return (A) this;
    }

    public Boolean hasGatewayTopology(){
            return this.gatewayTopology != null;
    }

    public ProxyConfigFluent.GatewayTopologyNested<A> withNewGatewayTopology(){
            return new GatewayTopologyNestedImpl();
    }

    public ProxyConfigFluent.GatewayTopologyNested<A> withNewGatewayTopologyLike(Topology item){
            return new GatewayTopologyNestedImpl(item);
    }

    public ProxyConfigFluent.GatewayTopologyNested<A> editGatewayTopology(){
            return withNewGatewayTopologyLike(getGatewayTopology());
    }

    public ProxyConfigFluent.GatewayTopologyNested<A> editOrNewGatewayTopology(){
            return withNewGatewayTopologyLike(getGatewayTopology() != null ? getGatewayTopology(): new TopologyBuilder().build());
    }

    public ProxyConfigFluent.GatewayTopologyNested<A> editOrNewGatewayTopologyLike(Topology item){
            return withNewGatewayTopologyLike(getGatewayTopology() != null ? getGatewayTopology(): item);
    }

    public InboundInterceptionMode getInterceptionMode(){
            return this.interceptionMode;
    }

    public A withInterceptionMode(InboundInterceptionMode interceptionMode){
            this.interceptionMode=interceptionMode; return (A) this;
    }

    public Boolean hasInterceptionMode(){
            return this.interceptionMode != null;
    }

    public String getMeshId(){
            return this.meshId;
    }

    public A withMeshId(String meshId){
            this.meshId=meshId; return (A) this;
    }

    public Boolean hasMeshId(){
            return this.meshId != null;
    }

    public A withNewMeshId(String arg1){
            return (A)withMeshId(new String(arg1));
    }

    public A withNewMeshId(StringBuilder arg1){
            return (A)withMeshId(new String(arg1));
    }

    public A withNewMeshId(StringBuffer arg1){
            return (A)withMeshId(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildParentShutdownDuration instead.
 * @return The buildable object.
 */
@Deprecated public Duration getParentShutdownDuration(){
            return this.parentShutdownDuration!=null?this.parentShutdownDuration.build():null;
    }

    public Duration buildParentShutdownDuration(){
            return this.parentShutdownDuration!=null?this.parentShutdownDuration.build():null;
    }

    public A withParentShutdownDuration(Duration parentShutdownDuration){
            _visitables.get("parentShutdownDuration").remove(this.parentShutdownDuration);
            if (parentShutdownDuration!=null){ this.parentShutdownDuration= new DurationBuilder(parentShutdownDuration); _visitables.get("parentShutdownDuration").add(this.parentShutdownDuration);} return (A) this;
    }

    public Boolean hasParentShutdownDuration(){
            return this.parentShutdownDuration != null;
    }

    public A withNewParentShutdownDuration(Integer nanos,Long seconds){
            return (A)withParentShutdownDuration(new Duration(nanos, seconds));
    }

    public ProxyConfigFluent.ParentShutdownDurationNested<A> withNewParentShutdownDuration(){
            return new ParentShutdownDurationNestedImpl();
    }

    public ProxyConfigFluent.ParentShutdownDurationNested<A> withNewParentShutdownDurationLike(Duration item){
            return new ParentShutdownDurationNestedImpl(item);
    }

    public ProxyConfigFluent.ParentShutdownDurationNested<A> editParentShutdownDuration(){
            return withNewParentShutdownDurationLike(getParentShutdownDuration());
    }

    public ProxyConfigFluent.ParentShutdownDurationNested<A> editOrNewParentShutdownDuration(){
            return withNewParentShutdownDurationLike(getParentShutdownDuration() != null ? getParentShutdownDuration(): new DurationBuilder().build());
    }

    public ProxyConfigFluent.ParentShutdownDurationNested<A> editOrNewParentShutdownDurationLike(Duration item){
            return withNewParentShutdownDurationLike(getParentShutdownDuration() != null ? getParentShutdownDuration(): item);
    }

    public Integer getProxyAdminPort(){
            return this.proxyAdminPort;
    }

    public A withProxyAdminPort(Integer proxyAdminPort){
            this.proxyAdminPort=proxyAdminPort; return (A) this;
    }

    public Boolean hasProxyAdminPort(){
            return this.proxyAdminPort != null;
    }

    public String getProxyBootstrapTemplatePath(){
            return this.proxyBootstrapTemplatePath;
    }

    public A withProxyBootstrapTemplatePath(String proxyBootstrapTemplatePath){
            this.proxyBootstrapTemplatePath=proxyBootstrapTemplatePath; return (A) this;
    }

    public Boolean hasProxyBootstrapTemplatePath(){
            return this.proxyBootstrapTemplatePath != null;
    }

    public A withNewProxyBootstrapTemplatePath(String arg1){
            return (A)withProxyBootstrapTemplatePath(new String(arg1));
    }

    public A withNewProxyBootstrapTemplatePath(StringBuilder arg1){
            return (A)withProxyBootstrapTemplatePath(new String(arg1));
    }

    public A withNewProxyBootstrapTemplatePath(StringBuffer arg1){
            return (A)withProxyBootstrapTemplatePath(new String(arg1));
    }

    public A addToProxyMetadata(String key,String value){
            if(this.proxyMetadata == null && key != null && value != null) { this.proxyMetadata = new LinkedHashMap<String,String>(); }
            if(key != null && value != null) {this.proxyMetadata.put(key, value);} return (A)this;
    }

    public A addToProxyMetadata(Map<String,String> map){
            if(this.proxyMetadata == null && map != null) { this.proxyMetadata = new LinkedHashMap<String,String>(); }
            if(map != null) { this.proxyMetadata.putAll(map);} return (A)this;
    }

    public A removeFromProxyMetadata(String key){
            if(this.proxyMetadata == null) { return (A) this; }
            if(key != null && this.proxyMetadata != null) {this.proxyMetadata.remove(key);} return (A)this;
    }

    public A removeFromProxyMetadata(Map<String,String> map){
            if(this.proxyMetadata == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.proxyMetadata != null){this.proxyMetadata.remove(key);}}} return (A)this;
    }

    public Map<String,String> getProxyMetadata(){
            return this.proxyMetadata;
    }

    public A withProxyMetadata(Map<String,String> proxyMetadata){
            if (proxyMetadata == null) { this.proxyMetadata =  null;} else {this.proxyMetadata = new LinkedHashMap<String,String>(proxyMetadata);} return (A) this;
    }

    public Boolean hasProxyMetadata(){
            return this.proxyMetadata != null;
    }

    
/**
 * This method has been deprecated, please use method buildSds instead.
 * @return The buildable object.
 */
@Deprecated public SDS getSds(){
            return this.sds!=null?this.sds.build():null;
    }

    public SDS buildSds(){
            return this.sds!=null?this.sds.build():null;
    }

    public A withSds(SDS sds){
            _visitables.get("sds").remove(this.sds);
            if (sds!=null){ this.sds= new SDSBuilder(sds); _visitables.get("sds").add(this.sds);} return (A) this;
    }

    public Boolean hasSds(){
            return this.sds != null;
    }

    public A withNewSds(Boolean enabled,String k8sSaJwtPath){
            return (A)withSds(new SDS(enabled, k8sSaJwtPath));
    }

    public ProxyConfigFluent.SdsNested<A> withNewSds(){
            return new SdsNestedImpl();
    }

    public ProxyConfigFluent.SdsNested<A> withNewSdsLike(SDS item){
            return new SdsNestedImpl(item);
    }

    public ProxyConfigFluent.SdsNested<A> editSds(){
            return withNewSdsLike(getSds());
    }

    public ProxyConfigFluent.SdsNested<A> editOrNewSds(){
            return withNewSdsLike(getSds() != null ? getSds(): new SDSBuilder().build());
    }

    public ProxyConfigFluent.SdsNested<A> editOrNewSdsLike(SDS item){
            return withNewSdsLike(getSds() != null ? getSds(): item);
    }

    public String getServiceCluster(){
            return this.serviceCluster;
    }

    public A withServiceCluster(String serviceCluster){
            this.serviceCluster=serviceCluster; return (A) this;
    }

    public Boolean hasServiceCluster(){
            return this.serviceCluster != null;
    }

    public A withNewServiceCluster(String arg1){
            return (A)withServiceCluster(new String(arg1));
    }

    public A withNewServiceCluster(StringBuilder arg1){
            return (A)withServiceCluster(new String(arg1));
    }

    public A withNewServiceCluster(StringBuffer arg1){
            return (A)withServiceCluster(new String(arg1));
    }

    public Integer getStatNameLength(){
            return this.statNameLength;
    }

    public A withStatNameLength(Integer statNameLength){
            this.statNameLength=statNameLength; return (A) this;
    }

    public Boolean hasStatNameLength(){
            return this.statNameLength != null;
    }

    public String getStatsdUdpAddress(){
            return this.statsdUdpAddress;
    }

    public A withStatsdUdpAddress(String statsdUdpAddress){
            this.statsdUdpAddress=statsdUdpAddress; return (A) this;
    }

    public Boolean hasStatsdUdpAddress(){
            return this.statsdUdpAddress != null;
    }

    public A withNewStatsdUdpAddress(String arg1){
            return (A)withStatsdUdpAddress(new String(arg1));
    }

    public A withNewStatsdUdpAddress(StringBuilder arg1){
            return (A)withStatsdUdpAddress(new String(arg1));
    }

    public A withNewStatsdUdpAddress(StringBuffer arg1){
            return (A)withStatsdUdpAddress(new String(arg1));
    }

    public Integer getStatusPort(){
            return this.statusPort;
    }

    public A withStatusPort(Integer statusPort){
            this.statusPort=statusPort; return (A) this;
    }

    public Boolean hasStatusPort(){
            return this.statusPort != null;
    }

    
/**
 * This method has been deprecated, please use method buildTerminationDrainDuration instead.
 * @return The buildable object.
 */
@Deprecated public Duration getTerminationDrainDuration(){
            return this.terminationDrainDuration!=null?this.terminationDrainDuration.build():null;
    }

    public Duration buildTerminationDrainDuration(){
            return this.terminationDrainDuration!=null?this.terminationDrainDuration.build():null;
    }

    public A withTerminationDrainDuration(Duration terminationDrainDuration){
            _visitables.get("terminationDrainDuration").remove(this.terminationDrainDuration);
            if (terminationDrainDuration!=null){ this.terminationDrainDuration= new DurationBuilder(terminationDrainDuration); _visitables.get("terminationDrainDuration").add(this.terminationDrainDuration);} return (A) this;
    }

    public Boolean hasTerminationDrainDuration(){
            return this.terminationDrainDuration != null;
    }

    public A withNewTerminationDrainDuration(Integer nanos,Long seconds){
            return (A)withTerminationDrainDuration(new Duration(nanos, seconds));
    }

    public ProxyConfigFluent.TerminationDrainDurationNested<A> withNewTerminationDrainDuration(){
            return new TerminationDrainDurationNestedImpl();
    }

    public ProxyConfigFluent.TerminationDrainDurationNested<A> withNewTerminationDrainDurationLike(Duration item){
            return new TerminationDrainDurationNestedImpl(item);
    }

    public ProxyConfigFluent.TerminationDrainDurationNested<A> editTerminationDrainDuration(){
            return withNewTerminationDrainDurationLike(getTerminationDrainDuration());
    }

    public ProxyConfigFluent.TerminationDrainDurationNested<A> editOrNewTerminationDrainDuration(){
            return withNewTerminationDrainDurationLike(getTerminationDrainDuration() != null ? getTerminationDrainDuration(): new DurationBuilder().build());
    }

    public ProxyConfigFluent.TerminationDrainDurationNested<A> editOrNewTerminationDrainDurationLike(Duration item){
            return withNewTerminationDrainDurationLike(getTerminationDrainDuration() != null ? getTerminationDrainDuration(): item);
    }

    
/**
 * This method has been deprecated, please use method buildTracing instead.
 * @return The buildable object.
 */
@Deprecated public Tracing getTracing(){
            return this.tracing!=null?this.tracing.build():null;
    }

    public Tracing buildTracing(){
            return this.tracing!=null?this.tracing.build():null;
    }

    public A withTracing(Tracing tracing){
            _visitables.get("tracing").remove(this.tracing);
            if (tracing!=null){ this.tracing= new TracingBuilder(tracing); _visitables.get("tracing").add(this.tracing);} return (A) this;
    }

    public Boolean hasTracing(){
            return this.tracing != null;
    }

    public ProxyConfigFluent.TracingNested<A> withNewTracing(){
            return new TracingNestedImpl();
    }

    public ProxyConfigFluent.TracingNested<A> withNewTracingLike(Tracing item){
            return new TracingNestedImpl(item);
    }

    public ProxyConfigFluent.TracingNested<A> editTracing(){
            return withNewTracingLike(getTracing());
    }

    public ProxyConfigFluent.TracingNested<A> editOrNewTracing(){
            return withNewTracingLike(getTracing() != null ? getTracing(): new TracingBuilder().build());
    }

    public ProxyConfigFluent.TracingNested<A> editOrNewTracingLike(Tracing item){
            return withNewTracingLike(getTracing() != null ? getTracing(): item);
    }

    public String getZipkinAddress(){
            return this.zipkinAddress;
    }

    public A withZipkinAddress(String zipkinAddress){
            this.zipkinAddress=zipkinAddress; return (A) this;
    }

    public Boolean hasZipkinAddress(){
            return this.zipkinAddress != null;
    }

    public A withNewZipkinAddress(String arg1){
            return (A)withZipkinAddress(new String(arg1));
    }

    public A withNewZipkinAddress(StringBuilder arg1){
            return (A)withZipkinAddress(new String(arg1));
    }

    public A withNewZipkinAddress(StringBuffer arg1){
            return (A)withZipkinAddress(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            ProxyConfigFluentImpl that = (ProxyConfigFluentImpl) o;
            if (availabilityZone != null ? !availabilityZone.equals(that.availabilityZone) :that.availabilityZone != null) return false;
            if (binaryPath != null ? !binaryPath.equals(that.binaryPath) :that.binaryPath != null) return false;
            if (concurrency != null ? !concurrency.equals(that.concurrency) :that.concurrency != null) return false;
            if (configPath != null ? !configPath.equals(that.configPath) :that.configPath != null) return false;
            if (controlPlaneAuthPolicy != null ? !controlPlaneAuthPolicy.equals(that.controlPlaneAuthPolicy) :that.controlPlaneAuthPolicy != null) return false;
            if (customConfigFile != null ? !customConfigFile.equals(that.customConfigFile) :that.customConfigFile != null) return false;
            if (discoveryAddress != null ? !discoveryAddress.equals(that.discoveryAddress) :that.discoveryAddress != null) return false;
            if (discoveryRefreshDelay != null ? !discoveryRefreshDelay.equals(that.discoveryRefreshDelay) :that.discoveryRefreshDelay != null) return false;
            if (drainDuration != null ? !drainDuration.equals(that.drainDuration) :that.drainDuration != null) return false;
            if (envoyAccessLogService != null ? !envoyAccessLogService.equals(that.envoyAccessLogService) :that.envoyAccessLogService != null) return false;
            if (envoyMetricsService != null ? !envoyMetricsService.equals(that.envoyMetricsService) :that.envoyMetricsService != null) return false;
            if (envoyMetricsServiceAddress != null ? !envoyMetricsServiceAddress.equals(that.envoyMetricsServiceAddress) :that.envoyMetricsServiceAddress != null) return false;
            if (extraStatTags != null ? !extraStatTags.equals(that.extraStatTags) :that.extraStatTags != null) return false;
            if (gatewayTopology != null ? !gatewayTopology.equals(that.gatewayTopology) :that.gatewayTopology != null) return false;
            if (interceptionMode != null ? !interceptionMode.equals(that.interceptionMode) :that.interceptionMode != null) return false;
            if (meshId != null ? !meshId.equals(that.meshId) :that.meshId != null) return false;
            if (parentShutdownDuration != null ? !parentShutdownDuration.equals(that.parentShutdownDuration) :that.parentShutdownDuration != null) return false;
            if (proxyAdminPort != null ? !proxyAdminPort.equals(that.proxyAdminPort) :that.proxyAdminPort != null) return false;
            if (proxyBootstrapTemplatePath != null ? !proxyBootstrapTemplatePath.equals(that.proxyBootstrapTemplatePath) :that.proxyBootstrapTemplatePath != null) return false;
            if (proxyMetadata != null ? !proxyMetadata.equals(that.proxyMetadata) :that.proxyMetadata != null) return false;
            if (sds != null ? !sds.equals(that.sds) :that.sds != null) return false;
            if (serviceCluster != null ? !serviceCluster.equals(that.serviceCluster) :that.serviceCluster != null) return false;
            if (statNameLength != null ? !statNameLength.equals(that.statNameLength) :that.statNameLength != null) return false;
            if (statsdUdpAddress != null ? !statsdUdpAddress.equals(that.statsdUdpAddress) :that.statsdUdpAddress != null) return false;
            if (statusPort != null ? !statusPort.equals(that.statusPort) :that.statusPort != null) return false;
            if (terminationDrainDuration != null ? !terminationDrainDuration.equals(that.terminationDrainDuration) :that.terminationDrainDuration != null) return false;
            if (tracing != null ? !tracing.equals(that.tracing) :that.tracing != null) return false;
            if (zipkinAddress != null ? !zipkinAddress.equals(that.zipkinAddress) :that.zipkinAddress != null) return false;
            return true;
    }


    public class ConcurrencyNestedImpl<N> extends Int32ValueFluentImpl<ProxyConfigFluent.ConcurrencyNested<N>> implements ProxyConfigFluent.ConcurrencyNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final Int32ValueBuilder builder;
    
            ConcurrencyNestedImpl(Int32Value item){
                    this.builder = new Int32ValueBuilder(this, item);
            }
            ConcurrencyNestedImpl(){
                    this.builder = new Int32ValueBuilder(this);
            }
    
    public N and(){
            return (N) ProxyConfigFluentImpl.this.withConcurrency(builder.build());
    }
    public N endConcurrency(){
            return and();
    }

}
    public class DiscoveryRefreshDelayNestedImpl<N> extends DurationFluentImpl<ProxyConfigFluent.DiscoveryRefreshDelayNested<N>> implements ProxyConfigFluent.DiscoveryRefreshDelayNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DurationBuilder builder;
    
            DiscoveryRefreshDelayNestedImpl(Duration item){
                    this.builder = new DurationBuilder(this, item);
            }
            DiscoveryRefreshDelayNestedImpl(){
                    this.builder = new DurationBuilder(this);
            }
    
    public N and(){
            return (N) ProxyConfigFluentImpl.this.withDiscoveryRefreshDelay(builder.build());
    }
    public N endDiscoveryRefreshDelay(){
            return and();
    }

}
    public class DrainDurationNestedImpl<N> extends DurationFluentImpl<ProxyConfigFluent.DrainDurationNested<N>> implements ProxyConfigFluent.DrainDurationNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DurationBuilder builder;
    
            DrainDurationNestedImpl(Duration item){
                    this.builder = new DurationBuilder(this, item);
            }
            DrainDurationNestedImpl(){
                    this.builder = new DurationBuilder(this);
            }
    
    public N and(){
            return (N) ProxyConfigFluentImpl.this.withDrainDuration(builder.build());
    }
    public N endDrainDuration(){
            return and();
    }

}
    public class EnvoyAccessLogServiceNestedImpl<N> extends RemoteServiceFluentImpl<ProxyConfigFluent.EnvoyAccessLogServiceNested<N>> implements ProxyConfigFluent.EnvoyAccessLogServiceNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final RemoteServiceBuilder builder;
    
            EnvoyAccessLogServiceNestedImpl(RemoteService item){
                    this.builder = new RemoteServiceBuilder(this, item);
            }
            EnvoyAccessLogServiceNestedImpl(){
                    this.builder = new RemoteServiceBuilder(this);
            }
    
    public N and(){
            return (N) ProxyConfigFluentImpl.this.withEnvoyAccessLogService(builder.build());
    }
    public N endEnvoyAccessLogService(){
            return and();
    }

}
    public class EnvoyMetricsServiceNestedImpl<N> extends RemoteServiceFluentImpl<ProxyConfigFluent.EnvoyMetricsServiceNested<N>> implements ProxyConfigFluent.EnvoyMetricsServiceNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final RemoteServiceBuilder builder;
    
            EnvoyMetricsServiceNestedImpl(RemoteService item){
                    this.builder = new RemoteServiceBuilder(this, item);
            }
            EnvoyMetricsServiceNestedImpl(){
                    this.builder = new RemoteServiceBuilder(this);
            }
    
    public N and(){
            return (N) ProxyConfigFluentImpl.this.withEnvoyMetricsService(builder.build());
    }
    public N endEnvoyMetricsService(){
            return and();
    }

}
    public class GatewayTopologyNestedImpl<N> extends TopologyFluentImpl<ProxyConfigFluent.GatewayTopologyNested<N>> implements ProxyConfigFluent.GatewayTopologyNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TopologyBuilder builder;
    
            GatewayTopologyNestedImpl(Topology item){
                    this.builder = new TopologyBuilder(this, item);
            }
            GatewayTopologyNestedImpl(){
                    this.builder = new TopologyBuilder(this);
            }
    
    public N and(){
            return (N) ProxyConfigFluentImpl.this.withGatewayTopology(builder.build());
    }
    public N endGatewayTopology(){
            return and();
    }

}
    public class ParentShutdownDurationNestedImpl<N> extends DurationFluentImpl<ProxyConfigFluent.ParentShutdownDurationNested<N>> implements ProxyConfigFluent.ParentShutdownDurationNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DurationBuilder builder;
    
            ParentShutdownDurationNestedImpl(Duration item){
                    this.builder = new DurationBuilder(this, item);
            }
            ParentShutdownDurationNestedImpl(){
                    this.builder = new DurationBuilder(this);
            }
    
    public N and(){
            return (N) ProxyConfigFluentImpl.this.withParentShutdownDuration(builder.build());
    }
    public N endParentShutdownDuration(){
            return and();
    }

}
    public class SdsNestedImpl<N> extends SDSFluentImpl<ProxyConfigFluent.SdsNested<N>> implements ProxyConfigFluent.SdsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final SDSBuilder builder;
    
            SdsNestedImpl(SDS item){
                    this.builder = new SDSBuilder(this, item);
            }
            SdsNestedImpl(){
                    this.builder = new SDSBuilder(this);
            }
    
    public N and(){
            return (N) ProxyConfigFluentImpl.this.withSds(builder.build());
    }
    public N endSds(){
            return and();
    }

}
    public class TerminationDrainDurationNestedImpl<N> extends DurationFluentImpl<ProxyConfigFluent.TerminationDrainDurationNested<N>> implements ProxyConfigFluent.TerminationDrainDurationNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DurationBuilder builder;
    
            TerminationDrainDurationNestedImpl(Duration item){
                    this.builder = new DurationBuilder(this, item);
            }
            TerminationDrainDurationNestedImpl(){
                    this.builder = new DurationBuilder(this);
            }
    
    public N and(){
            return (N) ProxyConfigFluentImpl.this.withTerminationDrainDuration(builder.build());
    }
    public N endTerminationDrainDuration(){
            return and();
    }

}
    public class TracingNestedImpl<N> extends TracingFluentImpl<ProxyConfigFluent.TracingNested<N>> implements ProxyConfigFluent.TracingNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TracingBuilder builder;
    
            TracingNestedImpl(Tracing item){
                    this.builder = new TracingBuilder(this, item);
            }
            TracingNestedImpl(){
                    this.builder = new TracingBuilder(this);
            }
    
    public N and(){
            return (N) ProxyConfigFluentImpl.this.withTracing(builder.build());
    }
    public N endTracing(){
            return and();
    }

}


}
