
package me.snowdrop.istio.api.mesh.v1alpha1;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.networking.v1alpha3.ClientTLSSettings;
import me.snowdrop.istio.api.networking.v1alpha3.TcpKeepalive;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "address",
    "tcpKeepalive",
    "tlsSettings"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class RemoteService implements Serializable
{

    /**
     * 
     */
    @JsonProperty("address")
    @JsonPropertyDescription("")
    private String address;
    /**
     * 
     */
    @JsonProperty("tcpKeepalive")
    @JsonPropertyDescription("")
    private TcpKeepalive tcpKeepalive;
    /**
     * 
     */
    @JsonProperty("tlsSettings")
    @JsonPropertyDescription("")
    private ClientTLSSettings tlsSettings;
    private final static long serialVersionUID = 3593542785679051817L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public RemoteService() {
    }

    /**
     * 
     * @param address
     * @param tcpKeepalive
     * @param tlsSettings
     */
    public RemoteService(String address, TcpKeepalive tcpKeepalive, ClientTLSSettings tlsSettings) {
        super();
        this.address = address;
        this.tcpKeepalive = tcpKeepalive;
        this.tlsSettings = tlsSettings;
    }

    /**
     * 
     */
    public String getAddress() {
        return address;
    }

    /**
     * 
     */
    public void setAddress(String address) {
        this.address = address;
    }

    /**
     * 
     */
    public TcpKeepalive getTcpKeepalive() {
        return tcpKeepalive;
    }

    /**
     * 
     */
    public void setTcpKeepalive(TcpKeepalive tcpKeepalive) {
        this.tcpKeepalive = tcpKeepalive;
    }

    /**
     * 
     */
    public ClientTLSSettings getTlsSettings() {
        return tlsSettings;
    }

    /**
     * 
     */
    public void setTlsSettings(ClientTLSSettings tlsSettings) {
        this.tlsSettings = tlsSettings;
    }

}
