package me.snowdrop.istio.api.mesh.v1alpha1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import me.snowdrop.istio.api.networking.v1alpha3.TcpKeepaliveFluentImpl;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import me.snowdrop.istio.api.networking.v1alpha3.ClientTLSSettingsBuilder;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import me.snowdrop.istio.api.networking.v1alpha3.TcpKeepaliveBuilder;
import java.lang.Object;
import me.snowdrop.istio.api.networking.v1alpha3.TcpKeepalive;
import java.lang.Boolean;
import me.snowdrop.istio.api.networking.v1alpha3.ClientTLSSettings;
import me.snowdrop.istio.api.networking.v1alpha3.ClientTLSSettingsFluentImpl;

public class RemoteServiceFluentImpl<A extends RemoteServiceFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements RemoteServiceFluent<A>{

    private String address;
    private TcpKeepaliveBuilder tcpKeepalive;
    private ClientTLSSettingsBuilder tlsSettings;

    public RemoteServiceFluentImpl(){
    }
    public RemoteServiceFluentImpl(RemoteService instance){
            this.withAddress(instance.getAddress()); 
            this.withTcpKeepalive(instance.getTcpKeepalive()); 
            this.withTlsSettings(instance.getTlsSettings()); 
    }

    public String getAddress(){
            return this.address;
    }

    public A withAddress(String address){
            this.address=address; return (A) this;
    }

    public Boolean hasAddress(){
            return this.address != null;
    }

    public A withNewAddress(String arg1){
            return (A)withAddress(new String(arg1));
    }

    public A withNewAddress(StringBuilder arg1){
            return (A)withAddress(new String(arg1));
    }

    public A withNewAddress(StringBuffer arg1){
            return (A)withAddress(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildTcpKeepalive instead.
 * @return The buildable object.
 */
@Deprecated public TcpKeepalive getTcpKeepalive(){
            return this.tcpKeepalive!=null?this.tcpKeepalive.build():null;
    }

    public TcpKeepalive buildTcpKeepalive(){
            return this.tcpKeepalive!=null?this.tcpKeepalive.build():null;
    }

    public A withTcpKeepalive(TcpKeepalive tcpKeepalive){
            _visitables.get("tcpKeepalive").remove(this.tcpKeepalive);
            if (tcpKeepalive!=null){ this.tcpKeepalive= new TcpKeepaliveBuilder(tcpKeepalive); _visitables.get("tcpKeepalive").add(this.tcpKeepalive);} return (A) this;
    }

    public Boolean hasTcpKeepalive(){
            return this.tcpKeepalive != null;
    }

    public RemoteServiceFluent.TcpKeepaliveNested<A> withNewTcpKeepalive(){
            return new TcpKeepaliveNestedImpl();
    }

    public RemoteServiceFluent.TcpKeepaliveNested<A> withNewTcpKeepaliveLike(TcpKeepalive item){
            return new TcpKeepaliveNestedImpl(item);
    }

    public RemoteServiceFluent.TcpKeepaliveNested<A> editTcpKeepalive(){
            return withNewTcpKeepaliveLike(getTcpKeepalive());
    }

    public RemoteServiceFluent.TcpKeepaliveNested<A> editOrNewTcpKeepalive(){
            return withNewTcpKeepaliveLike(getTcpKeepalive() != null ? getTcpKeepalive(): new TcpKeepaliveBuilder().build());
    }

    public RemoteServiceFluent.TcpKeepaliveNested<A> editOrNewTcpKeepaliveLike(TcpKeepalive item){
            return withNewTcpKeepaliveLike(getTcpKeepalive() != null ? getTcpKeepalive(): item);
    }

    
/**
 * This method has been deprecated, please use method buildTlsSettings instead.
 * @return The buildable object.
 */
@Deprecated public ClientTLSSettings getTlsSettings(){
            return this.tlsSettings!=null?this.tlsSettings.build():null;
    }

    public ClientTLSSettings buildTlsSettings(){
            return this.tlsSettings!=null?this.tlsSettings.build():null;
    }

    public A withTlsSettings(ClientTLSSettings tlsSettings){
            _visitables.get("tlsSettings").remove(this.tlsSettings);
            if (tlsSettings!=null){ this.tlsSettings= new ClientTLSSettingsBuilder(tlsSettings); _visitables.get("tlsSettings").add(this.tlsSettings);} return (A) this;
    }

    public Boolean hasTlsSettings(){
            return this.tlsSettings != null;
    }

    public RemoteServiceFluent.TlsSettingsNested<A> withNewTlsSettings(){
            return new TlsSettingsNestedImpl();
    }

    public RemoteServiceFluent.TlsSettingsNested<A> withNewTlsSettingsLike(ClientTLSSettings item){
            return new TlsSettingsNestedImpl(item);
    }

    public RemoteServiceFluent.TlsSettingsNested<A> editTlsSettings(){
            return withNewTlsSettingsLike(getTlsSettings());
    }

    public RemoteServiceFluent.TlsSettingsNested<A> editOrNewTlsSettings(){
            return withNewTlsSettingsLike(getTlsSettings() != null ? getTlsSettings(): new ClientTLSSettingsBuilder().build());
    }

    public RemoteServiceFluent.TlsSettingsNested<A> editOrNewTlsSettingsLike(ClientTLSSettings item){
            return withNewTlsSettingsLike(getTlsSettings() != null ? getTlsSettings(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            RemoteServiceFluentImpl that = (RemoteServiceFluentImpl) o;
            if (address != null ? !address.equals(that.address) :that.address != null) return false;
            if (tcpKeepalive != null ? !tcpKeepalive.equals(that.tcpKeepalive) :that.tcpKeepalive != null) return false;
            if (tlsSettings != null ? !tlsSettings.equals(that.tlsSettings) :that.tlsSettings != null) return false;
            return true;
    }


    public class TcpKeepaliveNestedImpl<N> extends TcpKeepaliveFluentImpl<RemoteServiceFluent.TcpKeepaliveNested<N>> implements RemoteServiceFluent.TcpKeepaliveNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TcpKeepaliveBuilder builder;
    
            TcpKeepaliveNestedImpl(TcpKeepalive item){
                    this.builder = new TcpKeepaliveBuilder(this, item);
            }
            TcpKeepaliveNestedImpl(){
                    this.builder = new TcpKeepaliveBuilder(this);
            }
    
    public N and(){
            return (N) RemoteServiceFluentImpl.this.withTcpKeepalive(builder.build());
    }
    public N endTcpKeepalive(){
            return and();
    }

}
    public class TlsSettingsNestedImpl<N> extends ClientTLSSettingsFluentImpl<RemoteServiceFluent.TlsSettingsNested<N>> implements RemoteServiceFluent.TlsSettingsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ClientTLSSettingsBuilder builder;
    
            TlsSettingsNestedImpl(ClientTLSSettings item){
                    this.builder = new ClientTLSSettingsBuilder(this, item);
            }
            TlsSettingsNestedImpl(){
                    this.builder = new ClientTLSSettingsBuilder(this);
            }
    
    public N and(){
            return (N) RemoteServiceFluentImpl.this.withTlsSettings(builder.build());
    }
    public N endTlsSettings(){
            return and();
    }

}


}
