package me.snowdrop.istio.api.mesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RequestHeaderBuilder extends RequestHeaderFluentImpl<RequestHeaderBuilder> implements VisitableBuilder<RequestHeader,RequestHeaderBuilder>{

    RequestHeaderFluent<?> fluent;
    Boolean validationEnabled;

    public RequestHeaderBuilder(){
            this(true);
    }
    public RequestHeaderBuilder(Boolean validationEnabled){
            this(new RequestHeader(), validationEnabled);
    }
    public RequestHeaderBuilder(RequestHeaderFluent<?> fluent){
            this(fluent, true);
    }
    public RequestHeaderBuilder(RequestHeaderFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new RequestHeader(), validationEnabled);
    }
    public RequestHeaderBuilder(RequestHeaderFluent<?> fluent,RequestHeader instance){
            this(fluent, instance, true);
    }
    public RequestHeaderBuilder(RequestHeaderFluent<?> fluent,RequestHeader instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withDefaultValue(instance.getDefaultValue()); 
            fluent.withName(instance.getName()); 
            this.validationEnabled = validationEnabled; 
    }
    public RequestHeaderBuilder(RequestHeader instance){
            this(instance,true);
    }
    public RequestHeaderBuilder(RequestHeader instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withDefaultValue(instance.getDefaultValue()); 
            this.withName(instance.getName()); 
            this.validationEnabled = validationEnabled; 
    }

    public RequestHeader build(){
            RequestHeader buildable = new RequestHeader(fluent.getDefaultValue(),fluent.getName());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RequestHeaderBuilder that = (RequestHeaderBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
