
package me.snowdrop.istio.api.mesh.v1alpha1;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "enabled",
    "k8sSaJwtPath"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class SDS implements Serializable
{

    /**
     * 
     */
    @JsonProperty("enabled")
    @JsonPropertyDescription("")
    private Boolean enabled;
    /**
     * 
     */
    @JsonProperty("k8sSaJwtPath")
    @JsonPropertyDescription("")
    private String k8sSaJwtPath;
    private final static long serialVersionUID = -3411064606849945434L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public SDS() {
    }

    /**
     * 
     * @param k8sSaJwtPath
     * @param enabled
     */
    public SDS(Boolean enabled, String k8sSaJwtPath) {
        super();
        this.enabled = enabled;
        this.k8sSaJwtPath = k8sSaJwtPath;
    }

    /**
     * 
     */
    public Boolean getEnabled() {
        return enabled;
    }

    /**
     * 
     */
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    /**
     * 
     */
    public String getK8sSaJwtPath() {
        return k8sSaJwtPath;
    }

    /**
     * 
     */
    public void setK8sSaJwtPath(String k8sSaJwtPath) {
        this.k8sSaJwtPath = k8sSaJwtPath;
    }

}
