package me.snowdrop.istio.api.mesh.v1alpha1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class SDSFluentImpl<A extends SDSFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements SDSFluent<A>{

    private Boolean enabled;
    private String k8sSaJwtPath;

    public SDSFluentImpl(){
    }
    public SDSFluentImpl(SDS instance){
            this.withEnabled(instance.getEnabled()); 
            this.withK8sSaJwtPath(instance.getK8sSaJwtPath()); 
    }

    public Boolean isEnabled(){
            return this.enabled;
    }

    public A withEnabled(Boolean enabled){
            this.enabled=enabled; return (A) this;
    }

    public Boolean hasEnabled(){
            return this.enabled != null;
    }

    public A withNewEnabled(String arg1){
            return (A)withEnabled(new Boolean(arg1));
    }

    public A withNewEnabled(boolean arg1){
            return (A)withEnabled(new Boolean(arg1));
    }

    public String getK8sSaJwtPath(){
            return this.k8sSaJwtPath;
    }

    public A withK8sSaJwtPath(String k8sSaJwtPath){
            this.k8sSaJwtPath=k8sSaJwtPath; return (A) this;
    }

    public Boolean hasK8sSaJwtPath(){
            return this.k8sSaJwtPath != null;
    }

    public A withNewK8sSaJwtPath(String arg1){
            return (A)withK8sSaJwtPath(new String(arg1));
    }

    public A withNewK8sSaJwtPath(StringBuilder arg1){
            return (A)withK8sSaJwtPath(new String(arg1));
    }

    public A withNewK8sSaJwtPath(StringBuffer arg1){
            return (A)withK8sSaJwtPath(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            SDSFluentImpl that = (SDSFluentImpl) o;
            if (enabled != null ? !enabled.equals(that.enabled) :that.enabled != null) return false;
            if (k8sSaJwtPath != null ? !k8sSaJwtPath.equals(that.k8sSaJwtPath) :that.k8sSaJwtPath != null) return false;
            return true;
    }




}
