
package me.snowdrop.istio.api.mesh.v1alpha1;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "hosts",
    "settings"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class ServiceSettings implements Serializable
{

    /**
     * 
     */
    @JsonProperty("hosts")
    @JsonPropertyDescription("")
    private List<String> hosts = new ArrayList<String>();
    /**
     * 
     */
    @JsonProperty("settings")
    @JsonPropertyDescription("")
    private Settings settings;
    private final static long serialVersionUID = 8648794578830846067L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ServiceSettings() {
    }

    /**
     * 
     * @param settings
     * @param hosts
     */
    public ServiceSettings(List<String> hosts, Settings settings) {
        super();
        this.hosts = hosts;
        this.settings = settings;
    }

    /**
     * 
     */
    public List<String> getHosts() {
        return hosts;
    }

    /**
     * 
     */
    public void setHosts(List<String> hosts) {
        this.hosts = hosts;
    }

    /**
     * 
     */
    public Settings getSettings() {
        return settings;
    }

    /**
     * 
     */
    public void setSettings(Settings settings) {
        this.settings = settings;
    }

}
