package me.snowdrop.istio.api.mesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ServiceSettingsBuilder extends ServiceSettingsFluentImpl<ServiceSettingsBuilder> implements VisitableBuilder<ServiceSettings,ServiceSettingsBuilder>{

    ServiceSettingsFluent<?> fluent;
    Boolean validationEnabled;

    public ServiceSettingsBuilder(){
            this(true);
    }
    public ServiceSettingsBuilder(Boolean validationEnabled){
            this(new ServiceSettings(), validationEnabled);
    }
    public ServiceSettingsBuilder(ServiceSettingsFluent<?> fluent){
            this(fluent, true);
    }
    public ServiceSettingsBuilder(ServiceSettingsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ServiceSettings(), validationEnabled);
    }
    public ServiceSettingsBuilder(ServiceSettingsFluent<?> fluent,ServiceSettings instance){
            this(fluent, instance, true);
    }
    public ServiceSettingsBuilder(ServiceSettingsFluent<?> fluent,ServiceSettings instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withHosts(instance.getHosts()); 
            fluent.withSettings(instance.getSettings()); 
            this.validationEnabled = validationEnabled; 
    }
    public ServiceSettingsBuilder(ServiceSettings instance){
            this(instance,true);
    }
    public ServiceSettingsBuilder(ServiceSettings instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withHosts(instance.getHosts()); 
            this.withSettings(instance.getSettings()); 
            this.validationEnabled = validationEnabled; 
    }

    public ServiceSettings build(){
            ServiceSettings buildable = new ServiceSettings(fluent.getHosts(),fluent.getSettings());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ServiceSettingsBuilder that = (ServiceSettingsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
