package me.snowdrop.istio.api.mesh.v1alpha1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface ServiceSettingsFluent<A extends ServiceSettingsFluent<A>> extends Fluent<A>{


    public A addToHosts(int index,String item);
    public A setToHosts(int index,String item);
    public A addToHosts(String... items);
    public A addAllToHosts(Collection<String> items);
    public A removeFromHosts(String... items);
    public A removeAllFromHosts(Collection<String> items);
    public List<String> getHosts();
    public String getHost(int index);
    public String getFirstHost();
    public String getLastHost();
    public String getMatchingHost(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public Boolean hasMatchingHost(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withHosts(List<String> hosts);
    public A withHosts(String... hosts);
    public Boolean hasHosts();
    public A addNewHost(String arg1);
    public A addNewHost(StringBuilder arg1);
    public A addNewHost(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildSettings instead.
 * @return The buildable object.
 */
@Deprecated public Settings getSettings();
    public Settings buildSettings();
    public A withSettings(Settings settings);
    public Boolean hasSettings();
    public A withNewSettings(Boolean clusterLocal);
    public ServiceSettingsFluent.SettingsNested<A> withNewSettings();
    public ServiceSettingsFluent.SettingsNested<A> withNewSettingsLike(Settings item);
    public ServiceSettingsFluent.SettingsNested<A> editSettings();
    public ServiceSettingsFluent.SettingsNested<A> editOrNewSettings();
    public ServiceSettingsFluent.SettingsNested<A> editOrNewSettingsLike(Settings item);

    public interface SettingsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SettingsFluent<ServiceSettingsFluent.SettingsNested<N>>{

        
    public N and();    public N endSettings();
}


}
