package me.snowdrop.istio.api.mesh.v1alpha1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class ServiceSettingsFluentImpl<A extends ServiceSettingsFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ServiceSettingsFluent<A>{

    private List<String> hosts;
    private SettingsBuilder settings;

    public ServiceSettingsFluentImpl(){
    }
    public ServiceSettingsFluentImpl(ServiceSettings instance){
            this.withHosts(instance.getHosts()); 
            this.withSettings(instance.getSettings()); 
    }

    public A addToHosts(int index,String item){
            if (this.hosts == null) {this.hosts = new ArrayList<String>();}
            this.hosts.add(index, item);
            return (A)this;
    }

    public A setToHosts(int index,String item){
            if (this.hosts == null) {this.hosts = new ArrayList<String>();}
            this.hosts.set(index, item); return (A)this;
    }

    public A addToHosts(String... items){
            if (this.hosts == null) {this.hosts = new ArrayList<String>();}
            for (String item : items) {this.hosts.add(item);} return (A)this;
    }

    public A addAllToHosts(Collection<String> items){
            if (this.hosts == null) {this.hosts = new ArrayList<String>();}
            for (String item : items) {this.hosts.add(item);} return (A)this;
    }

    public A removeFromHosts(String... items){
            for (String item : items) {if (this.hosts!= null){ this.hosts.remove(item);}} return (A)this;
    }

    public A removeAllFromHosts(Collection<String> items){
            for (String item : items) {if (this.hosts!= null){ this.hosts.remove(item);}} return (A)this;
    }

    public List<String> getHosts(){
            return this.hosts;
    }

    public String getHost(int index){
            return this.hosts.get(index);
    }

    public String getFirstHost(){
            return this.hosts.get(0);
    }

    public String getLastHost(){
            return this.hosts.get(hosts.size() - 1);
    }

    public String getMatchingHost(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: hosts) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingHost(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: hosts) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withHosts(List<String> hosts){
            if (this.hosts != null) { _visitables.get("hosts").removeAll(this.hosts);}
            if (hosts != null) {this.hosts = new ArrayList<String>(); for (String item : hosts){this.addToHosts(item);}} else { this.hosts = null;} return (A) this;
    }

    public A withHosts(String... hosts){
            if (this.hosts != null) {this.hosts.clear();}
            if (hosts != null) {for (String item :hosts){ this.addToHosts(item);}} return (A) this;
    }

    public Boolean hasHosts(){
            return hosts != null && !hosts.isEmpty();
    }

    public A addNewHost(String arg1){
            return (A)addToHosts(new String(arg1));
    }

    public A addNewHost(StringBuilder arg1){
            return (A)addToHosts(new String(arg1));
    }

    public A addNewHost(StringBuffer arg1){
            return (A)addToHosts(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildSettings instead.
 * @return The buildable object.
 */
@Deprecated public Settings getSettings(){
            return this.settings!=null?this.settings.build():null;
    }

    public Settings buildSettings(){
            return this.settings!=null?this.settings.build():null;
    }

    public A withSettings(Settings settings){
            _visitables.get("settings").remove(this.settings);
            if (settings!=null){ this.settings= new SettingsBuilder(settings); _visitables.get("settings").add(this.settings);} return (A) this;
    }

    public Boolean hasSettings(){
            return this.settings != null;
    }

    public A withNewSettings(Boolean clusterLocal){
            return (A)withSettings(new Settings(clusterLocal));
    }

    public ServiceSettingsFluent.SettingsNested<A> withNewSettings(){
            return new SettingsNestedImpl();
    }

    public ServiceSettingsFluent.SettingsNested<A> withNewSettingsLike(Settings item){
            return new SettingsNestedImpl(item);
    }

    public ServiceSettingsFluent.SettingsNested<A> editSettings(){
            return withNewSettingsLike(getSettings());
    }

    public ServiceSettingsFluent.SettingsNested<A> editOrNewSettings(){
            return withNewSettingsLike(getSettings() != null ? getSettings(): new SettingsBuilder().build());
    }

    public ServiceSettingsFluent.SettingsNested<A> editOrNewSettingsLike(Settings item){
            return withNewSettingsLike(getSettings() != null ? getSettings(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            ServiceSettingsFluentImpl that = (ServiceSettingsFluentImpl) o;
            if (hosts != null ? !hosts.equals(that.hosts) :that.hosts != null) return false;
            if (settings != null ? !settings.equals(that.settings) :that.settings != null) return false;
            return true;
    }


    public class SettingsNestedImpl<N> extends SettingsFluentImpl<ServiceSettingsFluent.SettingsNested<N>> implements ServiceSettingsFluent.SettingsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final SettingsBuilder builder;
    
            SettingsNestedImpl(Settings item){
                    this.builder = new SettingsBuilder(this, item);
            }
            SettingsNestedImpl(){
                    this.builder = new SettingsBuilder(this);
            }
    
    public N and(){
            return (N) ServiceSettingsFluentImpl.this.withSettings(builder.build());
    }
    public N endSettings(){
            return and();
    }

}


}
