
package me.snowdrop.istio.api.mesh.v1alpha1;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "clusterLocal"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Settings implements Serializable
{

    /**
     * 
     */
    @JsonProperty("clusterLocal")
    @JsonPropertyDescription("")
    private Boolean clusterLocal;
    private final static long serialVersionUID = 6909691995119095066L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Settings() {
    }

    /**
     * 
     * @param clusterLocal
     */
    public Settings(Boolean clusterLocal) {
        super();
        this.clusterLocal = clusterLocal;
    }

    /**
     * 
     */
    public Boolean getClusterLocal() {
        return clusterLocal;
    }

    /**
     * 
     */
    public void setClusterLocal(Boolean clusterLocal) {
        this.clusterLocal = clusterLocal;
    }

}
