package me.snowdrop.istio.api.mesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class SettingsBuilder extends SettingsFluentImpl<SettingsBuilder> implements VisitableBuilder<Settings,SettingsBuilder>{

    SettingsFluent<?> fluent;
    Boolean validationEnabled;

    public SettingsBuilder(){
            this(true);
    }
    public SettingsBuilder(Boolean validationEnabled){
            this(new Settings(), validationEnabled);
    }
    public SettingsBuilder(SettingsFluent<?> fluent){
            this(fluent, true);
    }
    public SettingsBuilder(SettingsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Settings(), validationEnabled);
    }
    public SettingsBuilder(SettingsFluent<?> fluent,Settings instance){
            this(fluent, instance, true);
    }
    public SettingsBuilder(SettingsFluent<?> fluent,Settings instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withClusterLocal(instance.getClusterLocal()); 
            this.validationEnabled = validationEnabled; 
    }
    public SettingsBuilder(Settings instance){
            this(instance,true);
    }
    public SettingsBuilder(Settings instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withClusterLocal(instance.getClusterLocal()); 
            this.validationEnabled = validationEnabled; 
    }

    public Settings build(){
            Settings buildable = new Settings(fluent.isClusterLocal());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SettingsBuilder that = (SettingsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
