package me.snowdrop.istio.api.mesh.v1alpha1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class SettingsFluentImpl<A extends SettingsFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements SettingsFluent<A>{

    private Boolean clusterLocal;

    public SettingsFluentImpl(){
    }
    public SettingsFluentImpl(Settings instance){
            this.withClusterLocal(instance.getClusterLocal()); 
    }

    public Boolean isClusterLocal(){
            return this.clusterLocal;
    }

    public A withClusterLocal(Boolean clusterLocal){
            this.clusterLocal=clusterLocal; return (A) this;
    }

    public Boolean hasClusterLocal(){
            return this.clusterLocal != null;
    }

    public A withNewClusterLocal(String arg1){
            return (A)withClusterLocal(new Boolean(arg1));
    }

    public A withNewClusterLocal(boolean arg1){
            return (A)withClusterLocal(new Boolean(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            SettingsFluentImpl that = (SettingsFluentImpl) o;
            if (clusterLocal != null ? !clusterLocal.equals(that.clusterLocal) :that.clusterLocal != null) return false;
            return true;
    }




}
