
package me.snowdrop.istio.api.mesh.v1alpha1;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.Duration;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "rateLimitTimeout",
    "rateLimitUrl"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class ThriftConfig implements Serializable
{

    /**
     * 
     */
    @JsonProperty("rateLimitTimeout")
    @JsonPropertyDescription("")
    private Duration rateLimitTimeout;
    /**
     * 
     */
    @JsonProperty("rateLimitUrl")
    @JsonPropertyDescription("")
    private String rateLimitUrl;
    private final static long serialVersionUID = 7739327290147771499L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ThriftConfig() {
    }

    /**
     * 
     * @param rateLimitUrl
     * @param rateLimitTimeout
     */
    public ThriftConfig(Duration rateLimitTimeout, String rateLimitUrl) {
        super();
        this.rateLimitTimeout = rateLimitTimeout;
        this.rateLimitUrl = rateLimitUrl;
    }

    /**
     * 
     */
    public Duration getRateLimitTimeout() {
        return rateLimitTimeout;
    }

    /**
     * 
     */
    public void setRateLimitTimeout(Duration rateLimitTimeout) {
        this.rateLimitTimeout = rateLimitTimeout;
    }

    /**
     * 
     */
    public String getRateLimitUrl() {
        return rateLimitUrl;
    }

    /**
     * 
     */
    public void setRateLimitUrl(String rateLimitUrl) {
        this.rateLimitUrl = rateLimitUrl;
    }

}
