package me.snowdrop.istio.api.mesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ThriftConfigBuilder extends ThriftConfigFluentImpl<ThriftConfigBuilder> implements VisitableBuilder<ThriftConfig,ThriftConfigBuilder>{

    ThriftConfigFluent<?> fluent;
    Boolean validationEnabled;

    public ThriftConfigBuilder(){
            this(true);
    }
    public ThriftConfigBuilder(Boolean validationEnabled){
            this(new ThriftConfig(), validationEnabled);
    }
    public ThriftConfigBuilder(ThriftConfigFluent<?> fluent){
            this(fluent, true);
    }
    public ThriftConfigBuilder(ThriftConfigFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ThriftConfig(), validationEnabled);
    }
    public ThriftConfigBuilder(ThriftConfigFluent<?> fluent,ThriftConfig instance){
            this(fluent, instance, true);
    }
    public ThriftConfigBuilder(ThriftConfigFluent<?> fluent,ThriftConfig instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withRateLimitTimeout(instance.getRateLimitTimeout()); 
            fluent.withRateLimitUrl(instance.getRateLimitUrl()); 
            this.validationEnabled = validationEnabled; 
    }
    public ThriftConfigBuilder(ThriftConfig instance){
            this(instance,true);
    }
    public ThriftConfigBuilder(ThriftConfig instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withRateLimitTimeout(instance.getRateLimitTimeout()); 
            this.withRateLimitUrl(instance.getRateLimitUrl()); 
            this.validationEnabled = validationEnabled; 
    }

    public ThriftConfig build(){
            ThriftConfig buildable = new ThriftConfig(fluent.getRateLimitTimeout(),fluent.getRateLimitUrl());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ThriftConfigBuilder that = (ThriftConfigBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
