package me.snowdrop.istio.api.mesh.v1alpha1;

import me.snowdrop.istio.api.DurationFluentImpl;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import com.fasterxml.jackson.databind.JsonSerializer;
import java.lang.String;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Boolean;
import java.lang.Override;
import com.fasterxml.jackson.core.JsonParser;
import me.snowdrop.istio.api.Duration;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Long;
import java.lang.Object;
import me.snowdrop.istio.api.DurationBuilder;

public class ThriftConfigFluentImpl<A extends ThriftConfigFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ThriftConfigFluent<A>{

    private DurationBuilder rateLimitTimeout;
    private String rateLimitUrl;

    public ThriftConfigFluentImpl(){
    }
    public ThriftConfigFluentImpl(ThriftConfig instance){
            this.withRateLimitTimeout(instance.getRateLimitTimeout()); 
            this.withRateLimitUrl(instance.getRateLimitUrl()); 
    }

    
/**
 * This method has been deprecated, please use method buildRateLimitTimeout instead.
 * @return The buildable object.
 */
@Deprecated public Duration getRateLimitTimeout(){
            return this.rateLimitTimeout!=null?this.rateLimitTimeout.build():null;
    }

    public Duration buildRateLimitTimeout(){
            return this.rateLimitTimeout!=null?this.rateLimitTimeout.build():null;
    }

    public A withRateLimitTimeout(Duration rateLimitTimeout){
            _visitables.get("rateLimitTimeout").remove(this.rateLimitTimeout);
            if (rateLimitTimeout!=null){ this.rateLimitTimeout= new DurationBuilder(rateLimitTimeout); _visitables.get("rateLimitTimeout").add(this.rateLimitTimeout);} return (A) this;
    }

    public Boolean hasRateLimitTimeout(){
            return this.rateLimitTimeout != null;
    }

    public A withNewRateLimitTimeout(Integer nanos,Long seconds){
            return (A)withRateLimitTimeout(new Duration(nanos, seconds));
    }

    public ThriftConfigFluent.RateLimitTimeoutNested<A> withNewRateLimitTimeout(){
            return new RateLimitTimeoutNestedImpl();
    }

    public ThriftConfigFluent.RateLimitTimeoutNested<A> withNewRateLimitTimeoutLike(Duration item){
            return new RateLimitTimeoutNestedImpl(item);
    }

    public ThriftConfigFluent.RateLimitTimeoutNested<A> editRateLimitTimeout(){
            return withNewRateLimitTimeoutLike(getRateLimitTimeout());
    }

    public ThriftConfigFluent.RateLimitTimeoutNested<A> editOrNewRateLimitTimeout(){
            return withNewRateLimitTimeoutLike(getRateLimitTimeout() != null ? getRateLimitTimeout(): new DurationBuilder().build());
    }

    public ThriftConfigFluent.RateLimitTimeoutNested<A> editOrNewRateLimitTimeoutLike(Duration item){
            return withNewRateLimitTimeoutLike(getRateLimitTimeout() != null ? getRateLimitTimeout(): item);
    }

    public String getRateLimitUrl(){
            return this.rateLimitUrl;
    }

    public A withRateLimitUrl(String rateLimitUrl){
            this.rateLimitUrl=rateLimitUrl; return (A) this;
    }

    public Boolean hasRateLimitUrl(){
            return this.rateLimitUrl != null;
    }

    public A withNewRateLimitUrl(String arg1){
            return (A)withRateLimitUrl(new String(arg1));
    }

    public A withNewRateLimitUrl(StringBuilder arg1){
            return (A)withRateLimitUrl(new String(arg1));
    }

    public A withNewRateLimitUrl(StringBuffer arg1){
            return (A)withRateLimitUrl(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            ThriftConfigFluentImpl that = (ThriftConfigFluentImpl) o;
            if (rateLimitTimeout != null ? !rateLimitTimeout.equals(that.rateLimitTimeout) :that.rateLimitTimeout != null) return false;
            if (rateLimitUrl != null ? !rateLimitUrl.equals(that.rateLimitUrl) :that.rateLimitUrl != null) return false;
            return true;
    }


    public class RateLimitTimeoutNestedImpl<N> extends DurationFluentImpl<ThriftConfigFluent.RateLimitTimeoutNested<N>> implements ThriftConfigFluent.RateLimitTimeoutNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DurationBuilder builder;
    
            RateLimitTimeoutNestedImpl(Duration item){
                    this.builder = new DurationBuilder(this, item);
            }
            RateLimitTimeoutNestedImpl(){
                    this.builder = new DurationBuilder(this);
            }
    
    public N and(){
            return (N) ThriftConfigFluentImpl.this.withRateLimitTimeout(builder.build());
    }
    public N endRateLimitTimeout(){
            return and();
    }

}


}
