
package me.snowdrop.istio.api.mesh.v1alpha1;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "forwardClientCertDetails",
    "numTrustedProxies"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Topology implements Serializable
{

    @JsonProperty("forwardClientCertDetails")
    private ForwardClientCertDetails forwardClientCertDetails;
    /**
     * 
     */
    @JsonProperty("numTrustedProxies")
    @JsonPropertyDescription("")
    private Integer numTrustedProxies;
    private final static long serialVersionUID = 457690852456467522L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Topology() {
    }

    /**
     * 
     * @param numTrustedProxies
     * @param forwardClientCertDetails
     */
    public Topology(ForwardClientCertDetails forwardClientCertDetails, Integer numTrustedProxies) {
        super();
        this.forwardClientCertDetails = forwardClientCertDetails;
        this.numTrustedProxies = numTrustedProxies;
    }

    public ForwardClientCertDetails getForwardClientCertDetails() {
        return forwardClientCertDetails;
    }

    public void setForwardClientCertDetails(ForwardClientCertDetails forwardClientCertDetails) {
        this.forwardClientCertDetails = forwardClientCertDetails;
    }

    /**
     * 
     */
    public Integer getNumTrustedProxies() {
        return numTrustedProxies;
    }

    /**
     * 
     */
    public void setNumTrustedProxies(Integer numTrustedProxies) {
        this.numTrustedProxies = numTrustedProxies;
    }

}
