package me.snowdrop.istio.api.mesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class TopologyBuilder extends TopologyFluentImpl<TopologyBuilder> implements VisitableBuilder<Topology,TopologyBuilder>{

    TopologyFluent<?> fluent;
    Boolean validationEnabled;

    public TopologyBuilder(){
            this(true);
    }
    public TopologyBuilder(Boolean validationEnabled){
            this(new Topology(), validationEnabled);
    }
    public TopologyBuilder(TopologyFluent<?> fluent){
            this(fluent, true);
    }
    public TopologyBuilder(TopologyFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Topology(), validationEnabled);
    }
    public TopologyBuilder(TopologyFluent<?> fluent,Topology instance){
            this(fluent, instance, true);
    }
    public TopologyBuilder(TopologyFluent<?> fluent,Topology instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withForwardClientCertDetails(instance.getForwardClientCertDetails()); 
            fluent.withNumTrustedProxies(instance.getNumTrustedProxies()); 
            this.validationEnabled = validationEnabled; 
    }
    public TopologyBuilder(Topology instance){
            this(instance,true);
    }
    public TopologyBuilder(Topology instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withForwardClientCertDetails(instance.getForwardClientCertDetails()); 
            this.withNumTrustedProxies(instance.getNumTrustedProxies()); 
            this.validationEnabled = validationEnabled; 
    }

    public Topology build(){
            Topology buildable = new Topology(fluent.getForwardClientCertDetails(),fluent.getNumTrustedProxies());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TopologyBuilder that = (TopologyBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
