package me.snowdrop.istio.api.mesh.v1alpha1;

import java.lang.Integer;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class TopologyFluentImpl<A extends TopologyFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements TopologyFluent<A>{

    private ForwardClientCertDetails forwardClientCertDetails;
    private Integer numTrustedProxies;

    public TopologyFluentImpl(){
    }
    public TopologyFluentImpl(Topology instance){
            this.withForwardClientCertDetails(instance.getForwardClientCertDetails()); 
            this.withNumTrustedProxies(instance.getNumTrustedProxies()); 
    }

    public ForwardClientCertDetails getForwardClientCertDetails(){
            return this.forwardClientCertDetails;
    }

    public A withForwardClientCertDetails(ForwardClientCertDetails forwardClientCertDetails){
            this.forwardClientCertDetails=forwardClientCertDetails; return (A) this;
    }

    public Boolean hasForwardClientCertDetails(){
            return this.forwardClientCertDetails != null;
    }

    public Integer getNumTrustedProxies(){
            return this.numTrustedProxies;
    }

    public A withNumTrustedProxies(Integer numTrustedProxies){
            this.numTrustedProxies=numTrustedProxies; return (A) this;
    }

    public Boolean hasNumTrustedProxies(){
            return this.numTrustedProxies != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            TopologyFluentImpl that = (TopologyFluentImpl) o;
            if (forwardClientCertDetails != null ? !forwardClientCertDetails.equals(that.forwardClientCertDetails) :that.forwardClientCertDetails != null) return false;
            if (numTrustedProxies != null ? !numTrustedProxies.equals(that.numTrustedProxies) :that.numTrustedProxies != null) return false;
            return true;
    }




}
