
package me.snowdrop.istio.api.mesh.v1alpha1;

import java.io.Serializable;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.networking.v1alpha3.ClientTLSSettings;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(using = me.snowdrop.istio.api.internal.ClassWithInterfaceFieldsDeserializer.class)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "customTags",
    "maxPathTagLength",
    "sampling",
    "tlsSettings",
    "tracer"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Tracing implements Serializable
{

    /**
     * 
     */
    @JsonProperty("customTags")
    @JsonPropertyDescription("")
    private Map<String, CustomTag> customTags;
    /**
     * 
     */
    @JsonProperty("maxPathTagLength")
    @JsonPropertyDescription("")
    private Integer maxPathTagLength;
    /**
     * 
     */
    @JsonProperty("sampling")
    @JsonPropertyDescription("")
    private Double sampling;
    /**
     * 
     */
    @JsonProperty("tlsSettings")
    @JsonPropertyDescription("")
    private ClientTLSSettings tlsSettings;
    @JsonProperty("tracer")
    @JsonUnwrapped
    private me.snowdrop.istio.api.mesh.v1alpha1.Tracing.Tracer tracer;
    private final static long serialVersionUID = 6712978541991843868L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Tracing() {
    }

    /**
     * 
     * @param customTags
     * @param sampling
     * @param tlsSettings
     * @param tracer
     * @param maxPathTagLength
     */
    public Tracing(Map<String, CustomTag> customTags, Integer maxPathTagLength, Double sampling, ClientTLSSettings tlsSettings, me.snowdrop.istio.api.mesh.v1alpha1.Tracing.Tracer tracer) {
        super();
        this.customTags = customTags;
        this.maxPathTagLength = maxPathTagLength;
        this.sampling = sampling;
        this.tlsSettings = tlsSettings;
        this.tracer = tracer;
    }

    /**
     * 
     */
    public Map<String, CustomTag> getCustomTags() {
        return customTags;
    }

    /**
     * 
     */
    public void setCustomTags(Map<String, CustomTag> customTags) {
        this.customTags = customTags;
    }

    /**
     * 
     */
    public Integer getMaxPathTagLength() {
        return maxPathTagLength;
    }

    /**
     * 
     */
    public void setMaxPathTagLength(Integer maxPathTagLength) {
        this.maxPathTagLength = maxPathTagLength;
    }

    /**
     * 
     */
    public Double getSampling() {
        return sampling;
    }

    /**
     * 
     */
    public void setSampling(Double sampling) {
        this.sampling = sampling;
    }

    /**
     * 
     */
    public ClientTLSSettings getTlsSettings() {
        return tlsSettings;
    }

    /**
     * 
     */
    public void setTlsSettings(ClientTLSSettings tlsSettings) {
        this.tlsSettings = tlsSettings;
    }

    public me.snowdrop.istio.api.mesh.v1alpha1.Tracing.Tracer getTracer() {
        return tracer;
    }

    public void setTracer(me.snowdrop.istio.api.mesh.v1alpha1.Tracing.Tracer tracer) {
        this.tracer = tracer;
    }

    public interface Tracer extends Serializable
    {


    }

}
