package me.snowdrop.istio.api.mesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class TracingBuilder extends TracingFluentImpl<TracingBuilder> implements VisitableBuilder<Tracing,TracingBuilder>{

    TracingFluent<?> fluent;
    Boolean validationEnabled;

    public TracingBuilder(){
            this(true);
    }
    public TracingBuilder(Boolean validationEnabled){
            this(new Tracing(), validationEnabled);
    }
    public TracingBuilder(TracingFluent<?> fluent){
            this(fluent, true);
    }
    public TracingBuilder(TracingFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Tracing(), validationEnabled);
    }
    public TracingBuilder(TracingFluent<?> fluent,Tracing instance){
            this(fluent, instance, true);
    }
    public TracingBuilder(TracingFluent<?> fluent,Tracing instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withCustomTags(instance.getCustomTags()); 
            fluent.withMaxPathTagLength(instance.getMaxPathTagLength()); 
            fluent.withSampling(instance.getSampling()); 
            fluent.withTlsSettings(instance.getTlsSettings()); 
            fluent.withTracer(instance.getTracer()); 
            this.validationEnabled = validationEnabled; 
    }
    public TracingBuilder(Tracing instance){
            this(instance,true);
    }
    public TracingBuilder(Tracing instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withCustomTags(instance.getCustomTags()); 
            this.withMaxPathTagLength(instance.getMaxPathTagLength()); 
            this.withSampling(instance.getSampling()); 
            this.withTlsSettings(instance.getTlsSettings()); 
            this.withTracer(instance.getTracer()); 
            this.validationEnabled = validationEnabled; 
    }

    public Tracing build(){
            Tracing buildable = new Tracing(fluent.getCustomTags(),fluent.getMaxPathTagLength(),fluent.getSampling(),fluent.getTlsSettings(),fluent.getTracer());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TracingBuilder that = (TracingBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
