package me.snowdrop.istio.api.mesh.v1alpha1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Double;
import java.util.LinkedHashMap;
import me.snowdrop.istio.api.networking.v1alpha3.ClientTLSSettingsBuilder;
import java.lang.Integer;
import me.snowdrop.istio.api.networking.v1alpha3.ClientTLSSettingsFluent;
import java.lang.Deprecated;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import java.lang.Boolean;
import java.util.Map;
import me.snowdrop.istio.api.networking.v1alpha3.ClientTLSSettings;

public interface TracingFluent<A extends TracingFluent<A>> extends Fluent<A>{


    public A addToCustomTags(String key,CustomTag value);
    public A addToCustomTags(Map<String,CustomTag> map);
    public A removeFromCustomTags(String key);
    public A removeFromCustomTags(Map<String,CustomTag> map);
    public Map<String,CustomTag> getCustomTags();
    public A withCustomTags(Map<String,CustomTag> customTags);
    public Boolean hasCustomTags();
    public Integer getMaxPathTagLength();
    public A withMaxPathTagLength(Integer maxPathTagLength);
    public Boolean hasMaxPathTagLength();
    public Double getSampling();
    public A withSampling(Double sampling);
    public Boolean hasSampling();
    
/**
 * This method has been deprecated, please use method buildTlsSettings instead.
 * @return The buildable object.
 */
@Deprecated public ClientTLSSettings getTlsSettings();
    public ClientTLSSettings buildTlsSettings();
    public A withTlsSettings(ClientTLSSettings tlsSettings);
    public Boolean hasTlsSettings();
    public TracingFluent.TlsSettingsNested<A> withNewTlsSettings();
    public TracingFluent.TlsSettingsNested<A> withNewTlsSettingsLike(ClientTLSSettings item);
    public TracingFluent.TlsSettingsNested<A> editTlsSettings();
    public TracingFluent.TlsSettingsNested<A> editOrNewTlsSettings();
    public TracingFluent.TlsSettingsNested<A> editOrNewTlsSettingsLike(ClientTLSSettings item);
    public Tracing.Tracer getTracer();
    public A withTracer(Tracing.Tracer tracer);
    public Boolean hasTracer();

    public interface TlsSettingsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ClientTLSSettingsFluent<TracingFluent.TlsSettingsNested<N>>{

        
    public N and();    public N endTlsSettings();
}


}
