package me.snowdrop.istio.api.mesh.v1alpha1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Double;
import java.util.LinkedHashMap;
import me.snowdrop.istio.api.networking.v1alpha3.ClientTLSSettingsBuilder;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import java.lang.Boolean;
import java.util.Map;
import me.snowdrop.istio.api.networking.v1alpha3.ClientTLSSettings;
import me.snowdrop.istio.api.networking.v1alpha3.ClientTLSSettingsFluentImpl;

public class TracingFluentImpl<A extends TracingFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements TracingFluent<A>{

    private Map<String,CustomTag> customTags;
    private Integer maxPathTagLength;
    private Double sampling;
    private ClientTLSSettingsBuilder tlsSettings;
    private Tracing.Tracer tracer;

    public TracingFluentImpl(){
    }
    public TracingFluentImpl(Tracing instance){
            this.withCustomTags(instance.getCustomTags()); 
            this.withMaxPathTagLength(instance.getMaxPathTagLength()); 
            this.withSampling(instance.getSampling()); 
            this.withTlsSettings(instance.getTlsSettings()); 
            this.withTracer(instance.getTracer()); 
    }

    public A addToCustomTags(String key,CustomTag value){
            if(this.customTags == null && key != null && value != null) { this.customTags = new LinkedHashMap<String,CustomTag>(); }
            if(key != null && value != null) {this.customTags.put(key, value);} return (A)this;
    }

    public A addToCustomTags(Map<String,CustomTag> map){
            if(this.customTags == null && map != null) { this.customTags = new LinkedHashMap<String,CustomTag>(); }
            if(map != null) { this.customTags.putAll(map);} return (A)this;
    }

    public A removeFromCustomTags(String key){
            if(this.customTags == null) { return (A) this; }
            if(key != null && this.customTags != null) {this.customTags.remove(key);} return (A)this;
    }

    public A removeFromCustomTags(Map<String,CustomTag> map){
            if(this.customTags == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.customTags != null){this.customTags.remove(key);}}} return (A)this;
    }

    public Map<String,CustomTag> getCustomTags(){
            return this.customTags;
    }

    public A withCustomTags(Map<String,CustomTag> customTags){
            if (customTags == null) { this.customTags =  null;} else {this.customTags = new LinkedHashMap<String,CustomTag>(customTags);} return (A) this;
    }

    public Boolean hasCustomTags(){
            return this.customTags != null;
    }

    public Integer getMaxPathTagLength(){
            return this.maxPathTagLength;
    }

    public A withMaxPathTagLength(Integer maxPathTagLength){
            this.maxPathTagLength=maxPathTagLength; return (A) this;
    }

    public Boolean hasMaxPathTagLength(){
            return this.maxPathTagLength != null;
    }

    public Double getSampling(){
            return this.sampling;
    }

    public A withSampling(Double sampling){
            this.sampling=sampling; return (A) this;
    }

    public Boolean hasSampling(){
            return this.sampling != null;
    }

    
/**
 * This method has been deprecated, please use method buildTlsSettings instead.
 * @return The buildable object.
 */
@Deprecated public ClientTLSSettings getTlsSettings(){
            return this.tlsSettings!=null?this.tlsSettings.build():null;
    }

    public ClientTLSSettings buildTlsSettings(){
            return this.tlsSettings!=null?this.tlsSettings.build():null;
    }

    public A withTlsSettings(ClientTLSSettings tlsSettings){
            _visitables.get("tlsSettings").remove(this.tlsSettings);
            if (tlsSettings!=null){ this.tlsSettings= new ClientTLSSettingsBuilder(tlsSettings); _visitables.get("tlsSettings").add(this.tlsSettings);} return (A) this;
    }

    public Boolean hasTlsSettings(){
            return this.tlsSettings != null;
    }

    public TracingFluent.TlsSettingsNested<A> withNewTlsSettings(){
            return new TlsSettingsNestedImpl();
    }

    public TracingFluent.TlsSettingsNested<A> withNewTlsSettingsLike(ClientTLSSettings item){
            return new TlsSettingsNestedImpl(item);
    }

    public TracingFluent.TlsSettingsNested<A> editTlsSettings(){
            return withNewTlsSettingsLike(getTlsSettings());
    }

    public TracingFluent.TlsSettingsNested<A> editOrNewTlsSettings(){
            return withNewTlsSettingsLike(getTlsSettings() != null ? getTlsSettings(): new ClientTLSSettingsBuilder().build());
    }

    public TracingFluent.TlsSettingsNested<A> editOrNewTlsSettingsLike(ClientTLSSettings item){
            return withNewTlsSettingsLike(getTlsSettings() != null ? getTlsSettings(): item);
    }

    public Tracing.Tracer getTracer(){
            return this.tracer;
    }

    public A withTracer(Tracing.Tracer tracer){
            this.tracer=tracer; return (A) this;
    }

    public Boolean hasTracer(){
            return this.tracer != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            TracingFluentImpl that = (TracingFluentImpl) o;
            if (customTags != null ? !customTags.equals(that.customTags) :that.customTags != null) return false;
            if (maxPathTagLength != null ? !maxPathTagLength.equals(that.maxPathTagLength) :that.maxPathTagLength != null) return false;
            if (sampling != null ? !sampling.equals(that.sampling) :that.sampling != null) return false;
            if (tlsSettings != null ? !tlsSettings.equals(that.tlsSettings) :that.tlsSettings != null) return false;
            if (tracer != null ? !tracer.equals(that.tracer) :that.tracer != null) return false;
            return true;
    }


    public class TlsSettingsNestedImpl<N> extends ClientTLSSettingsFluentImpl<TracingFluent.TlsSettingsNested<N>> implements TracingFluent.TlsSettingsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ClientTLSSettingsBuilder builder;
    
            TlsSettingsNestedImpl(ClientTLSSettings item){
                    this.builder = new ClientTLSSettingsBuilder(this, item);
            }
            TlsSettingsNestedImpl(){
                    this.builder = new ClientTLSSettingsBuilder(this);
            }
    
    public N and(){
            return (N) TracingFluentImpl.this.withTlsSettings(builder.build());
    }
    public N endTlsSettings(){
            return and();
    }

}


}
