
package me.snowdrop.istio.api.mixer.v1;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "condition",
    "mapKey",
    "name",
    "regex"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class AttributeMatch implements Serializable
{

    @JsonProperty("condition")
    private Condition condition;
    /**
     * 
     */
    @JsonProperty("mapKey")
    @JsonPropertyDescription("")
    private Integer mapKey;
    /**
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("")
    private Integer name;
    /**
     * 
     */
    @JsonProperty("regex")
    @JsonPropertyDescription("")
    private String regex;
    private final static long serialVersionUID = -3848984115317171277L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public AttributeMatch() {
    }

    /**
     * 
     * @param condition
     * @param regex
     * @param mapKey
     * @param name
     */
    public AttributeMatch(Condition condition, Integer mapKey, Integer name, String regex) {
        super();
        this.condition = condition;
        this.mapKey = mapKey;
        this.name = name;
        this.regex = regex;
    }

    public Condition getCondition() {
        return condition;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    /**
     * 
     */
    public Integer getMapKey() {
        return mapKey;
    }

    /**
     * 
     */
    public void setMapKey(Integer mapKey) {
        this.mapKey = mapKey;
    }

    /**
     * 
     */
    public Integer getName() {
        return name;
    }

    /**
     * 
     */
    public void setName(Integer name) {
        this.name = name;
    }

    /**
     * 
     */
    public String getRegex() {
        return regex;
    }

    /**
     * 
     */
    public void setRegex(String regex) {
        this.regex = regex;
    }

}
