
package me.snowdrop.istio.api.mixer.v1;

import java.io.Serializable;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.cexl.TypedValue;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "attributes"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Attributes implements Serializable
{

    /**
     * 
     */
    @JsonProperty("attributes")
    @JsonPropertyDescription("")
    private Map<String, TypedValue> attributes;
    private final static long serialVersionUID = -4708846258293470136L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Attributes() {
    }

    /**
     * 
     * @param attributes
     */
    public Attributes(Map<String, TypedValue> attributes) {
        super();
        this.attributes = attributes;
    }

    /**
     * 
     */
    public Map<String, TypedValue> getAttributes() {
        return attributes;
    }

    /**
     * 
     */
    public void setAttributes(Map<String, TypedValue> attributes) {
        this.attributes = attributes;
    }

}
