package me.snowdrop.istio.api.mixer.v1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;
import me.snowdrop.istio.api.cexl.TypedValue;

public class AttributesFluentImpl<A extends AttributesFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements AttributesFluent<A>{

    private Map<String,TypedValue> attributes;

    public AttributesFluentImpl(){
    }
    public AttributesFluentImpl(Attributes instance){
            this.withAttributes(instance.getAttributes()); 
    }

    public A addToAttributes(String key,TypedValue value){
            if(this.attributes == null && key != null && value != null) { this.attributes = new LinkedHashMap<String,TypedValue>(); }
            if(key != null && value != null) {this.attributes.put(key, value);} return (A)this;
    }

    public A addToAttributes(Map<String,TypedValue> map){
            if(this.attributes == null && map != null) { this.attributes = new LinkedHashMap<String,TypedValue>(); }
            if(map != null) { this.attributes.putAll(map);} return (A)this;
    }

    public A removeFromAttributes(String key){
            if(this.attributes == null) { return (A) this; }
            if(key != null && this.attributes != null) {this.attributes.remove(key);} return (A)this;
    }

    public A removeFromAttributes(Map<String,TypedValue> map){
            if(this.attributes == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.attributes != null){this.attributes.remove(key);}}} return (A)this;
    }

    public Map<String,TypedValue> getAttributes(){
            return this.attributes;
    }

    public A withAttributes(Map<String,TypedValue> attributes){
            if (attributes == null) { this.attributes =  null;} else {this.attributes = new LinkedHashMap<String,TypedValue>(attributes);} return (A) this;
    }

    public Boolean hasAttributes(){
            return this.attributes != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            AttributesFluentImpl that = (AttributesFluentImpl) o;
            if (attributes != null ? !attributes.equals(that.attributes) :that.attributes != null) return false;
            return true;
    }




}
