
package me.snowdrop.istio.api.mixer.v1;

import java.io.Serializable;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "precondition",
    "quotas"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class CheckResponse implements Serializable
{

    /**
     * 
     */
    @JsonProperty("precondition")
    @JsonPropertyDescription("")
    private PreconditionResult precondition;
    /**
     * 
     */
    @JsonProperty("quotas")
    @JsonPropertyDescription("")
    private Map<String, QuotaResult> quotas;
    private final static long serialVersionUID = 6521155807135740814L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public CheckResponse() {
    }

    /**
     * 
     * @param quotas
     * @param precondition
     */
    public CheckResponse(PreconditionResult precondition, Map<String, QuotaResult> quotas) {
        super();
        this.precondition = precondition;
        this.quotas = quotas;
    }

    /**
     * 
     */
    public PreconditionResult getPrecondition() {
        return precondition;
    }

    /**
     * 
     */
    public void setPrecondition(PreconditionResult precondition) {
        this.precondition = precondition;
    }

    /**
     * 
     */
    public Map<String, QuotaResult> getQuotas() {
        return quotas;
    }

    /**
     * 
     */
    public void setQuotas(Map<String, QuotaResult> quotas) {
        this.quotas = quotas;
    }

}
