package me.snowdrop.istio.api.mixer.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CheckResponseBuilder extends CheckResponseFluentImpl<CheckResponseBuilder> implements VisitableBuilder<CheckResponse,CheckResponseBuilder>{

    CheckResponseFluent<?> fluent;
    Boolean validationEnabled;

    public CheckResponseBuilder(){
            this(true);
    }
    public CheckResponseBuilder(Boolean validationEnabled){
            this(new CheckResponse(), validationEnabled);
    }
    public CheckResponseBuilder(CheckResponseFluent<?> fluent){
            this(fluent, true);
    }
    public CheckResponseBuilder(CheckResponseFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new CheckResponse(), validationEnabled);
    }
    public CheckResponseBuilder(CheckResponseFluent<?> fluent,CheckResponse instance){
            this(fluent, instance, true);
    }
    public CheckResponseBuilder(CheckResponseFluent<?> fluent,CheckResponse instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withPrecondition(instance.getPrecondition()); 
            fluent.withQuotas(instance.getQuotas()); 
            this.validationEnabled = validationEnabled; 
    }
    public CheckResponseBuilder(CheckResponse instance){
            this(instance,true);
    }
    public CheckResponseBuilder(CheckResponse instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withPrecondition(instance.getPrecondition()); 
            this.withQuotas(instance.getQuotas()); 
            this.validationEnabled = validationEnabled; 
    }

    public CheckResponse build(){
            CheckResponse buildable = new CheckResponse(fluent.getPrecondition(),fluent.getQuotas());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            CheckResponseBuilder that = (CheckResponseBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
