package me.snowdrop.istio.api.mixer.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PreconditionResultBuilder extends PreconditionResultFluentImpl<PreconditionResultBuilder> implements VisitableBuilder<PreconditionResult,PreconditionResultBuilder>{

    PreconditionResultFluent<?> fluent;
    Boolean validationEnabled;

    public PreconditionResultBuilder(){
            this(true);
    }
    public PreconditionResultBuilder(Boolean validationEnabled){
            this(new PreconditionResult(), validationEnabled);
    }
    public PreconditionResultBuilder(PreconditionResultFluent<?> fluent){
            this(fluent, true);
    }
    public PreconditionResultBuilder(PreconditionResultFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new PreconditionResult(), validationEnabled);
    }
    public PreconditionResultBuilder(PreconditionResultFluent<?> fluent,PreconditionResult instance){
            this(fluent, instance, true);
    }
    public PreconditionResultBuilder(PreconditionResultFluent<?> fluent,PreconditionResult instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withReferencedAttributes(instance.getReferencedAttributes()); 
            fluent.withRouteDirective(instance.getRouteDirective()); 
            fluent.withStatus(instance.getStatus()); 
            fluent.withValidDuration(instance.getValidDuration()); 
            fluent.withValidUseCount(instance.getValidUseCount()); 
            this.validationEnabled = validationEnabled; 
    }
    public PreconditionResultBuilder(PreconditionResult instance){
            this(instance,true);
    }
    public PreconditionResultBuilder(PreconditionResult instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withReferencedAttributes(instance.getReferencedAttributes()); 
            this.withRouteDirective(instance.getRouteDirective()); 
            this.withStatus(instance.getStatus()); 
            this.withValidDuration(instance.getValidDuration()); 
            this.withValidUseCount(instance.getValidUseCount()); 
            this.validationEnabled = validationEnabled; 
    }

    public PreconditionResult build(){
            PreconditionResult buildable = new PreconditionResult(fluent.getReferencedAttributes(),fluent.getRouteDirective(),fluent.getStatus(),fluent.getValidDuration(),fluent.getValidUseCount());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PreconditionResultBuilder that = (PreconditionResultBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
