package me.snowdrop.istio.api.mixer.v1;

import java.lang.Integer;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class QuotaParamsFluentImpl<A extends QuotaParamsFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements QuotaParamsFluent<A>{

    private Integer amount;
    private Boolean bestEffort;

    public QuotaParamsFluentImpl(){
    }
    public QuotaParamsFluentImpl(QuotaParams instance){
            this.withAmount(instance.getAmount()); 
            this.withBestEffort(instance.getBestEffort()); 
    }

    public Integer getAmount(){
            return this.amount;
    }

    public A withAmount(Integer amount){
            this.amount=amount; return (A) this;
    }

    public Boolean hasAmount(){
            return this.amount != null;
    }

    public Boolean isBestEffort(){
            return this.bestEffort;
    }

    public A withBestEffort(Boolean bestEffort){
            this.bestEffort=bestEffort; return (A) this;
    }

    public Boolean hasBestEffort(){
            return this.bestEffort != null;
    }

    public A withNewBestEffort(String arg1){
            return (A)withBestEffort(new Boolean(arg1));
    }

    public A withNewBestEffort(boolean arg1){
            return (A)withBestEffort(new Boolean(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            QuotaParamsFluentImpl that = (QuotaParamsFluentImpl) o;
            if (amount != null ? !amount.equals(that.amount) :that.amount != null) return false;
            if (bestEffort != null ? !bestEffort.equals(that.bestEffort) :that.bestEffort != null) return false;
            return true;
    }




}
