
package me.snowdrop.istio.api.mixer.v1;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.Status;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "grantedAmount",
    "referencedAttributes",
    "status",
    "validDuration"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class QuotaResult implements Serializable
{

    /**
     * 
     */
    @JsonProperty("grantedAmount")
    @JsonPropertyDescription("")
    private Integer grantedAmount;
    /**
     * 
     */
    @JsonProperty("referencedAttributes")
    @JsonPropertyDescription("")
    private ReferencedAttributes referencedAttributes;
    /**
     * 
     */
    @JsonProperty("status")
    @JsonPropertyDescription("")
    private Status status;
    /**
     * 
     */
    @JsonProperty("validDuration")
    @JsonPropertyDescription("")
    private Integer validDuration;
    private final static long serialVersionUID = -7078930497122552418L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public QuotaResult() {
    }

    /**
     * 
     * @param grantedAmount
     * @param referencedAttributes
     * @param validDuration
     * @param status
     */
    public QuotaResult(Integer grantedAmount, ReferencedAttributes referencedAttributes, Status status, Integer validDuration) {
        super();
        this.grantedAmount = grantedAmount;
        this.referencedAttributes = referencedAttributes;
        this.status = status;
        this.validDuration = validDuration;
    }

    /**
     * 
     */
    public Integer getGrantedAmount() {
        return grantedAmount;
    }

    /**
     * 
     */
    public void setGrantedAmount(Integer grantedAmount) {
        this.grantedAmount = grantedAmount;
    }

    /**
     * 
     */
    public ReferencedAttributes getReferencedAttributes() {
        return referencedAttributes;
    }

    /**
     * 
     */
    public void setReferencedAttributes(ReferencedAttributes referencedAttributes) {
        this.referencedAttributes = referencedAttributes;
    }

    /**
     * 
     */
    public Status getStatus() {
        return status;
    }

    /**
     * 
     */
    public void setStatus(Status status) {
        this.status = status;
    }

    /**
     * 
     */
    public Integer getValidDuration() {
        return validDuration;
    }

    /**
     * 
     */
    public void setValidDuration(Integer validDuration) {
        this.validDuration = validDuration;
    }

}
