package me.snowdrop.istio.api.mixer.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class QuotaResultBuilder extends QuotaResultFluentImpl<QuotaResultBuilder> implements VisitableBuilder<QuotaResult,QuotaResultBuilder>{

    QuotaResultFluent<?> fluent;
    Boolean validationEnabled;

    public QuotaResultBuilder(){
            this(true);
    }
    public QuotaResultBuilder(Boolean validationEnabled){
            this(new QuotaResult(), validationEnabled);
    }
    public QuotaResultBuilder(QuotaResultFluent<?> fluent){
            this(fluent, true);
    }
    public QuotaResultBuilder(QuotaResultFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new QuotaResult(), validationEnabled);
    }
    public QuotaResultBuilder(QuotaResultFluent<?> fluent,QuotaResult instance){
            this(fluent, instance, true);
    }
    public QuotaResultBuilder(QuotaResultFluent<?> fluent,QuotaResult instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withGrantedAmount(instance.getGrantedAmount()); 
            fluent.withReferencedAttributes(instance.getReferencedAttributes()); 
            fluent.withStatus(instance.getStatus()); 
            fluent.withValidDuration(instance.getValidDuration()); 
            this.validationEnabled = validationEnabled; 
    }
    public QuotaResultBuilder(QuotaResult instance){
            this(instance,true);
    }
    public QuotaResultBuilder(QuotaResult instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withGrantedAmount(instance.getGrantedAmount()); 
            this.withReferencedAttributes(instance.getReferencedAttributes()); 
            this.withStatus(instance.getStatus()); 
            this.withValidDuration(instance.getValidDuration()); 
            this.validationEnabled = validationEnabled; 
    }

    public QuotaResult build(){
            QuotaResult buildable = new QuotaResult(fluent.getGrantedAmount(),fluent.getReferencedAttributes(),fluent.getStatus(),fluent.getValidDuration());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            QuotaResultBuilder that = (QuotaResultBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
