
package me.snowdrop.istio.api.mixer.v1;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "attributeMatches",
    "words"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class ReferencedAttributes implements Serializable
{

    /**
     * 
     */
    @JsonProperty("attributeMatches")
    @JsonPropertyDescription("")
    private List<AttributeMatch> attributeMatches = new ArrayList<AttributeMatch>();
    /**
     * 
     */
    @JsonProperty("words")
    @JsonPropertyDescription("")
    private List<String> words = new ArrayList<String>();
    private final static long serialVersionUID = 1382499280985171L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ReferencedAttributes() {
    }

    /**
     * 
     * @param attributeMatches
     * @param words
     */
    public ReferencedAttributes(List<AttributeMatch> attributeMatches, List<String> words) {
        super();
        this.attributeMatches = attributeMatches;
        this.words = words;
    }

    /**
     * 
     */
    public List<AttributeMatch> getAttributeMatches() {
        return attributeMatches;
    }

    /**
     * 
     */
    public void setAttributeMatches(List<AttributeMatch> attributeMatches) {
        this.attributeMatches = attributeMatches;
    }

    /**
     * 
     */
    public List<String> getWords() {
        return words;
    }

    /**
     * 
     */
    public void setWords(List<String> words) {
        this.words = words;
    }

}
