
package me.snowdrop.istio.api.mixer.v1;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "directResponseBody",
    "directResponseCode",
    "requestHeaderOperations",
    "responseHeaderOperations"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class RouteDirective implements Serializable
{

    /**
     * 
     */
    @JsonProperty("directResponseBody")
    @JsonPropertyDescription("")
    private String directResponseBody;
    /**
     * 
     */
    @JsonProperty("directResponseCode")
    @JsonPropertyDescription("")
    private Integer directResponseCode;
    /**
     * 
     */
    @JsonProperty("requestHeaderOperations")
    @JsonPropertyDescription("")
    private List<HeaderOperation> requestHeaderOperations = new ArrayList<HeaderOperation>();
    /**
     * 
     */
    @JsonProperty("responseHeaderOperations")
    @JsonPropertyDescription("")
    private List<HeaderOperation> responseHeaderOperations = new ArrayList<HeaderOperation>();
    private final static long serialVersionUID = 8247425528789534643L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public RouteDirective() {
    }

    /**
     * 
     * @param directResponseBody
     * @param requestHeaderOperations
     * @param responseHeaderOperations
     * @param directResponseCode
     */
    public RouteDirective(String directResponseBody, Integer directResponseCode, List<HeaderOperation> requestHeaderOperations, List<HeaderOperation> responseHeaderOperations) {
        super();
        this.directResponseBody = directResponseBody;
        this.directResponseCode = directResponseCode;
        this.requestHeaderOperations = requestHeaderOperations;
        this.responseHeaderOperations = responseHeaderOperations;
    }

    /**
     * 
     */
    public String getDirectResponseBody() {
        return directResponseBody;
    }

    /**
     * 
     */
    public void setDirectResponseBody(String directResponseBody) {
        this.directResponseBody = directResponseBody;
    }

    /**
     * 
     */
    public Integer getDirectResponseCode() {
        return directResponseCode;
    }

    /**
     * 
     */
    public void setDirectResponseCode(Integer directResponseCode) {
        this.directResponseCode = directResponseCode;
    }

    /**
     * 
     */
    public List<HeaderOperation> getRequestHeaderOperations() {
        return requestHeaderOperations;
    }

    /**
     * 
     */
    public void setRequestHeaderOperations(List<HeaderOperation> requestHeaderOperations) {
        this.requestHeaderOperations = requestHeaderOperations;
    }

    /**
     * 
     */
    public List<HeaderOperation> getResponseHeaderOperations() {
        return responseHeaderOperations;
    }

    /**
     * 
     */
    public void setResponseHeaderOperations(List<HeaderOperation> responseHeaderOperations) {
        this.responseHeaderOperations = responseHeaderOperations;
    }

}
