package me.snowdrop.istio.api.mixer.v1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;

public class RouteDirectiveFluentImpl<A extends RouteDirectiveFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements RouteDirectiveFluent<A>{

    private String directResponseBody;
    private Integer directResponseCode;
    private List<HeaderOperationBuilder> requestHeaderOperations;
    private List<HeaderOperationBuilder> responseHeaderOperations;

    public RouteDirectiveFluentImpl(){
    }
    public RouteDirectiveFluentImpl(RouteDirective instance){
            this.withDirectResponseBody(instance.getDirectResponseBody()); 
            this.withDirectResponseCode(instance.getDirectResponseCode()); 
            this.withRequestHeaderOperations(instance.getRequestHeaderOperations()); 
            this.withResponseHeaderOperations(instance.getResponseHeaderOperations()); 
    }

    public String getDirectResponseBody(){
            return this.directResponseBody;
    }

    public A withDirectResponseBody(String directResponseBody){
            this.directResponseBody=directResponseBody; return (A) this;
    }

    public Boolean hasDirectResponseBody(){
            return this.directResponseBody != null;
    }

    public A withNewDirectResponseBody(String arg1){
            return (A)withDirectResponseBody(new String(arg1));
    }

    public A withNewDirectResponseBody(StringBuilder arg1){
            return (A)withDirectResponseBody(new String(arg1));
    }

    public A withNewDirectResponseBody(StringBuffer arg1){
            return (A)withDirectResponseBody(new String(arg1));
    }

    public Integer getDirectResponseCode(){
            return this.directResponseCode;
    }

    public A withDirectResponseCode(Integer directResponseCode){
            this.directResponseCode=directResponseCode; return (A) this;
    }

    public Boolean hasDirectResponseCode(){
            return this.directResponseCode != null;
    }

    public A addToRequestHeaderOperations(int index,HeaderOperation item){
            if (this.requestHeaderOperations == null) {this.requestHeaderOperations = new ArrayList<HeaderOperationBuilder>();}
            HeaderOperationBuilder builder = new HeaderOperationBuilder(item);_visitables.get("requestHeaderOperations").add(index >= 0 ? index : _visitables.get("requestHeaderOperations").size(), builder);this.requestHeaderOperations.add(index >= 0 ? index : requestHeaderOperations.size(), builder); return (A)this;
    }

    public A setToRequestHeaderOperations(int index,HeaderOperation item){
            if (this.requestHeaderOperations == null) {this.requestHeaderOperations = new ArrayList<HeaderOperationBuilder>();}
            HeaderOperationBuilder builder = new HeaderOperationBuilder(item);
            if (index < 0 || index >= _visitables.get("requestHeaderOperations").size()) { _visitables.get("requestHeaderOperations").add(builder); } else { _visitables.get("requestHeaderOperations").set(index, builder);}
            if (index < 0 || index >= requestHeaderOperations.size()) { requestHeaderOperations.add(builder); } else { requestHeaderOperations.set(index, builder);}
             return (A)this;
    }

    public A addToRequestHeaderOperations(HeaderOperation... items){
            if (this.requestHeaderOperations == null) {this.requestHeaderOperations = new ArrayList<HeaderOperationBuilder>();}
            for (HeaderOperation item : items) {HeaderOperationBuilder builder = new HeaderOperationBuilder(item);_visitables.get("requestHeaderOperations").add(builder);this.requestHeaderOperations.add(builder);} return (A)this;
    }

    public A addAllToRequestHeaderOperations(Collection<HeaderOperation> items){
            if (this.requestHeaderOperations == null) {this.requestHeaderOperations = new ArrayList<HeaderOperationBuilder>();}
            for (HeaderOperation item : items) {HeaderOperationBuilder builder = new HeaderOperationBuilder(item);_visitables.get("requestHeaderOperations").add(builder);this.requestHeaderOperations.add(builder);} return (A)this;
    }

    public A removeFromRequestHeaderOperations(HeaderOperation... items){
            for (HeaderOperation item : items) {HeaderOperationBuilder builder = new HeaderOperationBuilder(item);_visitables.get("requestHeaderOperations").remove(builder);if (this.requestHeaderOperations != null) {this.requestHeaderOperations.remove(builder);}} return (A)this;
    }

    public A removeAllFromRequestHeaderOperations(Collection<HeaderOperation> items){
            for (HeaderOperation item : items) {HeaderOperationBuilder builder = new HeaderOperationBuilder(item);_visitables.get("requestHeaderOperations").remove(builder);if (this.requestHeaderOperations != null) {this.requestHeaderOperations.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromRequestHeaderOperations(io.fabric8.kubernetes.api.builder.Predicate<HeaderOperationBuilder> predicate){
            if (requestHeaderOperations == null) return (A) this;
            final Iterator<HeaderOperationBuilder> each = requestHeaderOperations.iterator();
            final List visitables = _visitables.get("requestHeaderOperations");
            while (each.hasNext()) {
              HeaderOperationBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildRequestHeaderOperations instead.
 * @return The buildable object.
 */
@Deprecated public List<HeaderOperation> getRequestHeaderOperations(){
            return build(requestHeaderOperations);
    }

    public List<HeaderOperation> buildRequestHeaderOperations(){
            return build(requestHeaderOperations);
    }

    public HeaderOperation buildRequestHeaderOperation(int index){
            return this.requestHeaderOperations.get(index).build();
    }

    public HeaderOperation buildFirstRequestHeaderOperation(){
            return this.requestHeaderOperations.get(0).build();
    }

    public HeaderOperation buildLastRequestHeaderOperation(){
            return this.requestHeaderOperations.get(requestHeaderOperations.size() - 1).build();
    }

    public HeaderOperation buildMatchingRequestHeaderOperation(io.fabric8.kubernetes.api.builder.Predicate<HeaderOperationBuilder> predicate){
            for (HeaderOperationBuilder item: requestHeaderOperations) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingRequestHeaderOperation(io.fabric8.kubernetes.api.builder.Predicate<HeaderOperationBuilder> predicate){
            for (HeaderOperationBuilder item: requestHeaderOperations) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withRequestHeaderOperations(List<HeaderOperation> requestHeaderOperations){
            if (this.requestHeaderOperations != null) { _visitables.get("requestHeaderOperations").removeAll(this.requestHeaderOperations);}
            if (requestHeaderOperations != null) {this.requestHeaderOperations = new ArrayList<HeaderOperationBuilder>(); for (HeaderOperation item : requestHeaderOperations){this.addToRequestHeaderOperations(item);}} else { this.requestHeaderOperations = null;} return (A) this;
    }

    public A withRequestHeaderOperations(HeaderOperation... requestHeaderOperations){
            if (this.requestHeaderOperations != null) {this.requestHeaderOperations.clear();}
            if (requestHeaderOperations != null) {for (HeaderOperation item :requestHeaderOperations){ this.addToRequestHeaderOperations(item);}} return (A) this;
    }

    public Boolean hasRequestHeaderOperations(){
            return requestHeaderOperations != null && !requestHeaderOperations.isEmpty();
    }

    public RouteDirectiveFluent.RequestHeaderOperationsNested<A> addNewRequestHeaderOperation(){
            return new RequestHeaderOperationsNestedImpl();
    }

    public RouteDirectiveFluent.RequestHeaderOperationsNested<A> addNewRequestHeaderOperationLike(HeaderOperation item){
            return new RequestHeaderOperationsNestedImpl(-1, item);
    }

    public RouteDirectiveFluent.RequestHeaderOperationsNested<A> setNewRequestHeaderOperationLike(int index,HeaderOperation item){
            return new RequestHeaderOperationsNestedImpl(index, item);
    }

    public RouteDirectiveFluent.RequestHeaderOperationsNested<A> editRequestHeaderOperation(int index){
            if (requestHeaderOperations.size() <= index) throw new RuntimeException("Can't edit requestHeaderOperations. Index exceeds size.");
            return setNewRequestHeaderOperationLike(index, buildRequestHeaderOperation(index));
    }

    public RouteDirectiveFluent.RequestHeaderOperationsNested<A> editFirstRequestHeaderOperation(){
            if (requestHeaderOperations.size() == 0) throw new RuntimeException("Can't edit first requestHeaderOperations. The list is empty.");
            return setNewRequestHeaderOperationLike(0, buildRequestHeaderOperation(0));
    }

    public RouteDirectiveFluent.RequestHeaderOperationsNested<A> editLastRequestHeaderOperation(){
            int index = requestHeaderOperations.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last requestHeaderOperations. The list is empty.");
            return setNewRequestHeaderOperationLike(index, buildRequestHeaderOperation(index));
    }

    public RouteDirectiveFluent.RequestHeaderOperationsNested<A> editMatchingRequestHeaderOperation(io.fabric8.kubernetes.api.builder.Predicate<HeaderOperationBuilder> predicate){
            int index = -1;
            for (int i=0;i<requestHeaderOperations.size();i++) { 
            if (predicate.apply(requestHeaderOperations.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching requestHeaderOperations. No match found.");
            return setNewRequestHeaderOperationLike(index, buildRequestHeaderOperation(index));
    }

    public A addToResponseHeaderOperations(int index,HeaderOperation item){
            if (this.responseHeaderOperations == null) {this.responseHeaderOperations = new ArrayList<HeaderOperationBuilder>();}
            HeaderOperationBuilder builder = new HeaderOperationBuilder(item);_visitables.get("responseHeaderOperations").add(index >= 0 ? index : _visitables.get("responseHeaderOperations").size(), builder);this.responseHeaderOperations.add(index >= 0 ? index : responseHeaderOperations.size(), builder); return (A)this;
    }

    public A setToResponseHeaderOperations(int index,HeaderOperation item){
            if (this.responseHeaderOperations == null) {this.responseHeaderOperations = new ArrayList<HeaderOperationBuilder>();}
            HeaderOperationBuilder builder = new HeaderOperationBuilder(item);
            if (index < 0 || index >= _visitables.get("responseHeaderOperations").size()) { _visitables.get("responseHeaderOperations").add(builder); } else { _visitables.get("responseHeaderOperations").set(index, builder);}
            if (index < 0 || index >= responseHeaderOperations.size()) { responseHeaderOperations.add(builder); } else { responseHeaderOperations.set(index, builder);}
             return (A)this;
    }

    public A addToResponseHeaderOperations(HeaderOperation... items){
            if (this.responseHeaderOperations == null) {this.responseHeaderOperations = new ArrayList<HeaderOperationBuilder>();}
            for (HeaderOperation item : items) {HeaderOperationBuilder builder = new HeaderOperationBuilder(item);_visitables.get("responseHeaderOperations").add(builder);this.responseHeaderOperations.add(builder);} return (A)this;
    }

    public A addAllToResponseHeaderOperations(Collection<HeaderOperation> items){
            if (this.responseHeaderOperations == null) {this.responseHeaderOperations = new ArrayList<HeaderOperationBuilder>();}
            for (HeaderOperation item : items) {HeaderOperationBuilder builder = new HeaderOperationBuilder(item);_visitables.get("responseHeaderOperations").add(builder);this.responseHeaderOperations.add(builder);} return (A)this;
    }

    public A removeFromResponseHeaderOperations(HeaderOperation... items){
            for (HeaderOperation item : items) {HeaderOperationBuilder builder = new HeaderOperationBuilder(item);_visitables.get("responseHeaderOperations").remove(builder);if (this.responseHeaderOperations != null) {this.responseHeaderOperations.remove(builder);}} return (A)this;
    }

    public A removeAllFromResponseHeaderOperations(Collection<HeaderOperation> items){
            for (HeaderOperation item : items) {HeaderOperationBuilder builder = new HeaderOperationBuilder(item);_visitables.get("responseHeaderOperations").remove(builder);if (this.responseHeaderOperations != null) {this.responseHeaderOperations.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromResponseHeaderOperations(io.fabric8.kubernetes.api.builder.Predicate<HeaderOperationBuilder> predicate){
            if (responseHeaderOperations == null) return (A) this;
            final Iterator<HeaderOperationBuilder> each = responseHeaderOperations.iterator();
            final List visitables = _visitables.get("responseHeaderOperations");
            while (each.hasNext()) {
              HeaderOperationBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildResponseHeaderOperations instead.
 * @return The buildable object.
 */
@Deprecated public List<HeaderOperation> getResponseHeaderOperations(){
            return build(responseHeaderOperations);
    }

    public List<HeaderOperation> buildResponseHeaderOperations(){
            return build(responseHeaderOperations);
    }

    public HeaderOperation buildResponseHeaderOperation(int index){
            return this.responseHeaderOperations.get(index).build();
    }

    public HeaderOperation buildFirstResponseHeaderOperation(){
            return this.responseHeaderOperations.get(0).build();
    }

    public HeaderOperation buildLastResponseHeaderOperation(){
            return this.responseHeaderOperations.get(responseHeaderOperations.size() - 1).build();
    }

    public HeaderOperation buildMatchingResponseHeaderOperation(io.fabric8.kubernetes.api.builder.Predicate<HeaderOperationBuilder> predicate){
            for (HeaderOperationBuilder item: responseHeaderOperations) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingResponseHeaderOperation(io.fabric8.kubernetes.api.builder.Predicate<HeaderOperationBuilder> predicate){
            for (HeaderOperationBuilder item: responseHeaderOperations) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withResponseHeaderOperations(List<HeaderOperation> responseHeaderOperations){
            if (this.responseHeaderOperations != null) { _visitables.get("responseHeaderOperations").removeAll(this.responseHeaderOperations);}
            if (responseHeaderOperations != null) {this.responseHeaderOperations = new ArrayList<HeaderOperationBuilder>(); for (HeaderOperation item : responseHeaderOperations){this.addToResponseHeaderOperations(item);}} else { this.responseHeaderOperations = null;} return (A) this;
    }

    public A withResponseHeaderOperations(HeaderOperation... responseHeaderOperations){
            if (this.responseHeaderOperations != null) {this.responseHeaderOperations.clear();}
            if (responseHeaderOperations != null) {for (HeaderOperation item :responseHeaderOperations){ this.addToResponseHeaderOperations(item);}} return (A) this;
    }

    public Boolean hasResponseHeaderOperations(){
            return responseHeaderOperations != null && !responseHeaderOperations.isEmpty();
    }

    public RouteDirectiveFluent.ResponseHeaderOperationsNested<A> addNewResponseHeaderOperation(){
            return new ResponseHeaderOperationsNestedImpl();
    }

    public RouteDirectiveFluent.ResponseHeaderOperationsNested<A> addNewResponseHeaderOperationLike(HeaderOperation item){
            return new ResponseHeaderOperationsNestedImpl(-1, item);
    }

    public RouteDirectiveFluent.ResponseHeaderOperationsNested<A> setNewResponseHeaderOperationLike(int index,HeaderOperation item){
            return new ResponseHeaderOperationsNestedImpl(index, item);
    }

    public RouteDirectiveFluent.ResponseHeaderOperationsNested<A> editResponseHeaderOperation(int index){
            if (responseHeaderOperations.size() <= index) throw new RuntimeException("Can't edit responseHeaderOperations. Index exceeds size.");
            return setNewResponseHeaderOperationLike(index, buildResponseHeaderOperation(index));
    }

    public RouteDirectiveFluent.ResponseHeaderOperationsNested<A> editFirstResponseHeaderOperation(){
            if (responseHeaderOperations.size() == 0) throw new RuntimeException("Can't edit first responseHeaderOperations. The list is empty.");
            return setNewResponseHeaderOperationLike(0, buildResponseHeaderOperation(0));
    }

    public RouteDirectiveFluent.ResponseHeaderOperationsNested<A> editLastResponseHeaderOperation(){
            int index = responseHeaderOperations.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last responseHeaderOperations. The list is empty.");
            return setNewResponseHeaderOperationLike(index, buildResponseHeaderOperation(index));
    }

    public RouteDirectiveFluent.ResponseHeaderOperationsNested<A> editMatchingResponseHeaderOperation(io.fabric8.kubernetes.api.builder.Predicate<HeaderOperationBuilder> predicate){
            int index = -1;
            for (int i=0;i<responseHeaderOperations.size();i++) { 
            if (predicate.apply(responseHeaderOperations.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching responseHeaderOperations. No match found.");
            return setNewResponseHeaderOperationLike(index, buildResponseHeaderOperation(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            RouteDirectiveFluentImpl that = (RouteDirectiveFluentImpl) o;
            if (directResponseBody != null ? !directResponseBody.equals(that.directResponseBody) :that.directResponseBody != null) return false;
            if (directResponseCode != null ? !directResponseCode.equals(that.directResponseCode) :that.directResponseCode != null) return false;
            if (requestHeaderOperations != null ? !requestHeaderOperations.equals(that.requestHeaderOperations) :that.requestHeaderOperations != null) return false;
            if (responseHeaderOperations != null ? !responseHeaderOperations.equals(that.responseHeaderOperations) :that.responseHeaderOperations != null) return false;
            return true;
    }


    public class RequestHeaderOperationsNestedImpl<N> extends HeaderOperationFluentImpl<RouteDirectiveFluent.RequestHeaderOperationsNested<N>> implements RouteDirectiveFluent.RequestHeaderOperationsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final HeaderOperationBuilder builder;
        private final int index;
    
            RequestHeaderOperationsNestedImpl(int index,HeaderOperation item){
                    this.index = index;
                    this.builder = new HeaderOperationBuilder(this, item);
            }
            RequestHeaderOperationsNestedImpl(){
                    this.index = -1;
                    this.builder = new HeaderOperationBuilder(this);
            }
    
    public N and(){
            return (N) RouteDirectiveFluentImpl.this.setToRequestHeaderOperations(index,builder.build());
    }
    public N endRequestHeaderOperation(){
            return and();
    }

}
    public class ResponseHeaderOperationsNestedImpl<N> extends HeaderOperationFluentImpl<RouteDirectiveFluent.ResponseHeaderOperationsNested<N>> implements RouteDirectiveFluent.ResponseHeaderOperationsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final HeaderOperationBuilder builder;
        private final int index;
    
            ResponseHeaderOperationsNestedImpl(int index,HeaderOperation item){
                    this.index = index;
                    this.builder = new HeaderOperationBuilder(this, item);
            }
            ResponseHeaderOperationsNestedImpl(){
                    this.index = -1;
                    this.builder = new HeaderOperationBuilder(this);
            }
    
    public N and(){
            return (N) RouteDirectiveFluentImpl.this.setToResponseHeaderOperations(index,builder.build());
    }
    public N endResponseHeaderOperation(){
            return and();
    }

}


}
