package me.snowdrop.istio.api.model;

import io.fabric8.kubernetes.api.KubernetesResourceMappingProvider;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.HashMap;
import java.util.Map;

public class IstioResourceMappingsProvider implements KubernetesResourceMappingProvider {

    public final Map<String, Class<? extends KubernetesResource>> mappings = new HashMap<>();

    public IstioResourceMappingsProvider () {

        mappings.put("networking.istio.io/v1alpha3#VirtualService", me.snowdrop.istio.api.networking.v1alpha3.VirtualService.class);
        mappings.put("networking.istio.io/v1beta1#WorkloadEntry", me.snowdrop.istio.api.networking.v1beta1.WorkloadEntry.class);
        mappings.put("security.istio.io/v1beta1#AuthorizationPolicy", me.snowdrop.istio.api.security.v1beta1.AuthorizationPolicy.class);
        mappings.put("security.istio.io/v1beta1#RequestAuthentication", me.snowdrop.istio.api.security.v1beta1.RequestAuthentication.class);
        mappings.put("security.istio.io/v1beta1#PeerAuthentication", me.snowdrop.istio.api.security.v1beta1.PeerAuthentication.class);
        mappings.put("networking.istio.io/v1beta1#Sidecar", me.snowdrop.istio.api.networking.v1beta1.Sidecar.class);
        mappings.put("networking.istio.io/v1alpha3#EnvoyFilter", me.snowdrop.istio.api.networking.v1alpha3.EnvoyFilter.class);
        mappings.put("networking.istio.io/v1alpha3#DestinationRule", me.snowdrop.istio.api.networking.v1alpha3.DestinationRule.class);
        mappings.put("networking.istio.io/v1alpha3#Gateway", me.snowdrop.istio.api.networking.v1alpha3.Gateway.class);
        mappings.put("networking.istio.io/v1alpha3#WorkloadEntry", me.snowdrop.istio.api.networking.v1alpha3.WorkloadEntry.class);
        mappings.put("networking.istio.io/v1alpha3#ServiceEntry", me.snowdrop.istio.api.networking.v1alpha3.ServiceEntry.class);
        mappings.put("config.istio.io/v1alpha2#handler", me.snowdrop.istio.api.policy.v1beta1.Handler.class);
        mappings.put("networking.istio.io/v1beta1#ServiceEntry", me.snowdrop.istio.api.networking.v1beta1.ServiceEntry.class);
        mappings.put("networking.istio.io/v1alpha3#Sidecar", me.snowdrop.istio.api.networking.v1alpha3.Sidecar.class);
        mappings.put("networking.istio.io/v1beta1#VirtualService", me.snowdrop.istio.api.networking.v1beta1.VirtualService.class);
        mappings.put("config.istio.io/v1alpha2#instance", me.snowdrop.istio.api.policy.v1beta1.Instance.class);
        mappings.put("networking.istio.io/v1beta1#Gateway", me.snowdrop.istio.api.networking.v1beta1.Gateway.class);
        mappings.put("networking.istio.io/v1beta1#DestinationRule", me.snowdrop.istio.api.networking.v1beta1.DestinationRule.class);
    }

    public Map<String, Class<? extends KubernetesResource>> getMappings() {
        return mappings;
    }
}
