package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class AbortBuilder extends AbortFluentImpl<AbortBuilder> implements VisitableBuilder<Abort,AbortBuilder>{

    AbortFluent<?> fluent;
    Boolean validationEnabled;

    public AbortBuilder(){
            this(true);
    }
    public AbortBuilder(Boolean validationEnabled){
            this(new Abort(), validationEnabled);
    }
    public AbortBuilder(AbortFluent<?> fluent){
            this(fluent, true);
    }
    public AbortBuilder(AbortFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Abort(), validationEnabled);
    }
    public AbortBuilder(AbortFluent<?> fluent,Abort instance){
            this(fluent, instance, true);
    }
    public AbortBuilder(AbortFluent<?> fluent,Abort instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withErrorType(instance.getErrorType()); 
            fluent.withPercentage(instance.getPercentage()); 
            this.validationEnabled = validationEnabled; 
    }
    public AbortBuilder(Abort instance){
            this(instance,true);
    }
    public AbortBuilder(Abort instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withErrorType(instance.getErrorType()); 
            this.withPercentage(instance.getPercentage()); 
            this.validationEnabled = validationEnabled; 
    }

    public Abort build(){
            Abort buildable = new Abort(fluent.getErrorType(),fluent.getPercentage());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            AbortBuilder that = (AbortBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
