
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "name",
    "portNumber",
    "service",
    "subset"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class ClusterMatch implements Serializable
{

    /**
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("")
    private String name;
    /**
     * 
     */
    @JsonProperty("portNumber")
    @JsonPropertyDescription("")
    private Integer portNumber;
    /**
     * 
     */
    @JsonProperty("service")
    @JsonPropertyDescription("")
    private String service;
    /**
     * 
     */
    @JsonProperty("subset")
    @JsonPropertyDescription("")
    private String subset;
    private final static long serialVersionUID = -3265119515781984838L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ClusterMatch() {
    }

    /**
     * 
     * @param service
     * @param name
     * @param portNumber
     * @param subset
     */
    public ClusterMatch(String name, Integer portNumber, String service, String subset) {
        super();
        this.name = name;
        this.portNumber = portNumber;
        this.service = service;
        this.subset = subset;
    }

    /**
     * 
     */
    public String getName() {
        return name;
    }

    /**
     * 
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * 
     */
    public Integer getPortNumber() {
        return portNumber;
    }

    /**
     * 
     */
    public void setPortNumber(Integer portNumber) {
        this.portNumber = portNumber;
    }

    /**
     * 
     */
    public String getService() {
        return service;
    }

    /**
     * 
     */
    public void setService(String service) {
        this.service = service;
    }

    /**
     * 
     */
    public String getSubset() {
        return subset;
    }

    /**
     * 
     */
    public void setSubset(String subset) {
        this.subset = subset;
    }

}
