package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ClusterMatchBuilder extends ClusterMatchFluentImpl<ClusterMatchBuilder> implements VisitableBuilder<ClusterMatch,ClusterMatchBuilder>{

    ClusterMatchFluent<?> fluent;
    Boolean validationEnabled;

    public ClusterMatchBuilder(){
            this(true);
    }
    public ClusterMatchBuilder(Boolean validationEnabled){
            this(new ClusterMatch(), validationEnabled);
    }
    public ClusterMatchBuilder(ClusterMatchFluent<?> fluent){
            this(fluent, true);
    }
    public ClusterMatchBuilder(ClusterMatchFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ClusterMatch(), validationEnabled);
    }
    public ClusterMatchBuilder(ClusterMatchFluent<?> fluent,ClusterMatch instance){
            this(fluent, instance, true);
    }
    public ClusterMatchBuilder(ClusterMatchFluent<?> fluent,ClusterMatch instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withName(instance.getName()); 
            fluent.withPortNumber(instance.getPortNumber()); 
            fluent.withService(instance.getService()); 
            fluent.withSubset(instance.getSubset()); 
            this.validationEnabled = validationEnabled; 
    }
    public ClusterMatchBuilder(ClusterMatch instance){
            this(instance,true);
    }
    public ClusterMatchBuilder(ClusterMatch instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withName(instance.getName()); 
            this.withPortNumber(instance.getPortNumber()); 
            this.withService(instance.getService()); 
            this.withSubset(instance.getSubset()); 
            this.validationEnabled = validationEnabled; 
    }

    public ClusterMatch build(){
            ClusterMatch buildable = new ClusterMatch(fluent.getName(),fluent.getPortNumber(),fluent.getService(),fluent.getSubset());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ClusterMatchBuilder that = (ClusterMatchBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
