package me.snowdrop.istio.api.networking.v1alpha3;

import java.lang.Integer;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class ClusterMatchFluentImpl<A extends ClusterMatchFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ClusterMatchFluent<A>{

    private String name;
    private Integer portNumber;
    private String service;
    private String subset;

    public ClusterMatchFluentImpl(){
    }
    public ClusterMatchFluentImpl(ClusterMatch instance){
            this.withName(instance.getName()); 
            this.withPortNumber(instance.getPortNumber()); 
            this.withService(instance.getService()); 
            this.withSubset(instance.getSubset()); 
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name != null;
    }

    public A withNewName(String arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1){
            return (A)withName(new String(arg1));
    }

    public Integer getPortNumber(){
            return this.portNumber;
    }

    public A withPortNumber(Integer portNumber){
            this.portNumber=portNumber; return (A) this;
    }

    public Boolean hasPortNumber(){
            return this.portNumber != null;
    }

    public String getService(){
            return this.service;
    }

    public A withService(String service){
            this.service=service; return (A) this;
    }

    public Boolean hasService(){
            return this.service != null;
    }

    public A withNewService(String arg1){
            return (A)withService(new String(arg1));
    }

    public A withNewService(StringBuilder arg1){
            return (A)withService(new String(arg1));
    }

    public A withNewService(StringBuffer arg1){
            return (A)withService(new String(arg1));
    }

    public String getSubset(){
            return this.subset;
    }

    public A withSubset(String subset){
            this.subset=subset; return (A) this;
    }

    public Boolean hasSubset(){
            return this.subset != null;
    }

    public A withNewSubset(String arg1){
            return (A)withSubset(new String(arg1));
    }

    public A withNewSubset(StringBuilder arg1){
            return (A)withSubset(new String(arg1));
    }

    public A withNewSubset(StringBuffer arg1){
            return (A)withSubset(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            ClusterMatchFluentImpl that = (ClusterMatchFluentImpl) o;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (portNumber != null ? !portNumber.equals(that.portNumber) :that.portNumber != null) return false;
            if (service != null ? !service.equals(that.service) :that.service != null) return false;
            if (subset != null ? !subset.equals(that.subset) :that.subset != null) return false;
            return true;
    }




}
