
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.networking.v1alpha3.EnvoyConfigObjectMatch.ObjectTypes;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "cluster"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class ClusterObjectTypes implements Serializable, ObjectTypes
{

    /**
     * 
     */
    @JsonProperty("cluster")
    @JsonPropertyDescription("")
    private ClusterMatch cluster;
    private final static long serialVersionUID = -3306849689818935627L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ClusterObjectTypes() {
    }

    /**
     * 
     * @param cluster
     */
    public ClusterObjectTypes(ClusterMatch cluster) {
        super();
        this.cluster = cluster;
    }

    /**
     * 
     */
    public ClusterMatch getCluster() {
        return cluster;
    }

    /**
     * 
     */
    public void setCluster(ClusterMatch cluster) {
        this.cluster = cluster;
    }

}
