package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ClusterObjectTypesBuilder extends ClusterObjectTypesFluentImpl<ClusterObjectTypesBuilder> implements VisitableBuilder<ClusterObjectTypes,ClusterObjectTypesBuilder>{

    ClusterObjectTypesFluent<?> fluent;
    Boolean validationEnabled;

    public ClusterObjectTypesBuilder(){
            this(true);
    }
    public ClusterObjectTypesBuilder(Boolean validationEnabled){
            this(new ClusterObjectTypes(), validationEnabled);
    }
    public ClusterObjectTypesBuilder(ClusterObjectTypesFluent<?> fluent){
            this(fluent, true);
    }
    public ClusterObjectTypesBuilder(ClusterObjectTypesFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ClusterObjectTypes(), validationEnabled);
    }
    public ClusterObjectTypesBuilder(ClusterObjectTypesFluent<?> fluent,ClusterObjectTypes instance){
            this(fluent, instance, true);
    }
    public ClusterObjectTypesBuilder(ClusterObjectTypesFluent<?> fluent,ClusterObjectTypes instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withCluster(instance.getCluster()); 
            this.validationEnabled = validationEnabled; 
    }
    public ClusterObjectTypesBuilder(ClusterObjectTypes instance){
            this(instance,true);
    }
    public ClusterObjectTypesBuilder(ClusterObjectTypes instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withCluster(instance.getCluster()); 
            this.validationEnabled = validationEnabled; 
    }

    public ClusterObjectTypes build(){
            ClusterObjectTypes buildable = new ClusterObjectTypes(fluent.getCluster());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ClusterObjectTypesBuilder that = (ClusterObjectTypesBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
