package me.snowdrop.istio.api.networking.v1alpha3;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class ClusterObjectTypesFluentImpl<A extends ClusterObjectTypesFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ClusterObjectTypesFluent<A>{

    private ClusterMatchBuilder cluster;

    public ClusterObjectTypesFluentImpl(){
    }
    public ClusterObjectTypesFluentImpl(ClusterObjectTypes instance){
            this.withCluster(instance.getCluster()); 
    }

    
/**
 * This method has been deprecated, please use method buildCluster instead.
 * @return The buildable object.
 */
@Deprecated public ClusterMatch getCluster(){
            return this.cluster!=null?this.cluster.build():null;
    }

    public ClusterMatch buildCluster(){
            return this.cluster!=null?this.cluster.build():null;
    }

    public A withCluster(ClusterMatch cluster){
            _visitables.get("cluster").remove(this.cluster);
            if (cluster!=null){ this.cluster= new ClusterMatchBuilder(cluster); _visitables.get("cluster").add(this.cluster);} return (A) this;
    }

    public Boolean hasCluster(){
            return this.cluster != null;
    }

    public A withNewCluster(String name,Integer portNumber,String service,String subset){
            return (A)withCluster(new ClusterMatch(name, portNumber, service, subset));
    }

    public ClusterObjectTypesFluent.ClusterNested<A> withNewCluster(){
            return new ClusterNestedImpl();
    }

    public ClusterObjectTypesFluent.ClusterNested<A> withNewClusterLike(ClusterMatch item){
            return new ClusterNestedImpl(item);
    }

    public ClusterObjectTypesFluent.ClusterNested<A> editCluster(){
            return withNewClusterLike(getCluster());
    }

    public ClusterObjectTypesFluent.ClusterNested<A> editOrNewCluster(){
            return withNewClusterLike(getCluster() != null ? getCluster(): new ClusterMatchBuilder().build());
    }

    public ClusterObjectTypesFluent.ClusterNested<A> editOrNewClusterLike(ClusterMatch item){
            return withNewClusterLike(getCluster() != null ? getCluster(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            ClusterObjectTypesFluentImpl that = (ClusterObjectTypesFluentImpl) o;
            if (cluster != null ? !cluster.equals(that.cluster) :that.cluster != null) return false;
            return true;
    }


    public class ClusterNestedImpl<N> extends ClusterMatchFluentImpl<ClusterObjectTypesFluent.ClusterNested<N>> implements ClusterObjectTypesFluent.ClusterNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ClusterMatchBuilder builder;
    
            ClusterNestedImpl(ClusterMatch item){
                    this.builder = new ClusterMatchBuilder(this, item);
            }
            ClusterNestedImpl(){
                    this.builder = new ClusterMatchBuilder(this);
            }
    
    public N and(){
            return (N) ClusterObjectTypesFluentImpl.this.withCluster(builder.build());
    }
    public N endCluster(){
            return and();
    }

}


}
