package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ConnectionPoolSettingsBuilder extends ConnectionPoolSettingsFluentImpl<ConnectionPoolSettingsBuilder> implements VisitableBuilder<ConnectionPoolSettings,ConnectionPoolSettingsBuilder>{

    ConnectionPoolSettingsFluent<?> fluent;
    Boolean validationEnabled;

    public ConnectionPoolSettingsBuilder(){
            this(true);
    }
    public ConnectionPoolSettingsBuilder(Boolean validationEnabled){
            this(new ConnectionPoolSettings(), validationEnabled);
    }
    public ConnectionPoolSettingsBuilder(ConnectionPoolSettingsFluent<?> fluent){
            this(fluent, true);
    }
    public ConnectionPoolSettingsBuilder(ConnectionPoolSettingsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ConnectionPoolSettings(), validationEnabled);
    }
    public ConnectionPoolSettingsBuilder(ConnectionPoolSettingsFluent<?> fluent,ConnectionPoolSettings instance){
            this(fluent, instance, true);
    }
    public ConnectionPoolSettingsBuilder(ConnectionPoolSettingsFluent<?> fluent,ConnectionPoolSettings instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withHttp(instance.getHttp()); 
            fluent.withTcp(instance.getTcp()); 
            this.validationEnabled = validationEnabled; 
    }
    public ConnectionPoolSettingsBuilder(ConnectionPoolSettings instance){
            this(instance,true);
    }
    public ConnectionPoolSettingsBuilder(ConnectionPoolSettings instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withHttp(instance.getHttp()); 
            this.withTcp(instance.getTcp()); 
            this.validationEnabled = validationEnabled; 
    }

    public ConnectionPoolSettings build(){
            ConnectionPoolSettings buildable = new ConnectionPoolSettings(fluent.getHttp(),fluent.getTcp());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ConnectionPoolSettingsBuilder that = (ConnectionPoolSettingsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
