package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ConsistentHashLbPolicyBuilder extends ConsistentHashLbPolicyFluentImpl<ConsistentHashLbPolicyBuilder> implements VisitableBuilder<ConsistentHashLbPolicy,ConsistentHashLbPolicyBuilder>{

    ConsistentHashLbPolicyFluent<?> fluent;
    Boolean validationEnabled;

    public ConsistentHashLbPolicyBuilder(){
            this(true);
    }
    public ConsistentHashLbPolicyBuilder(Boolean validationEnabled){
            this(new ConsistentHashLbPolicy(), validationEnabled);
    }
    public ConsistentHashLbPolicyBuilder(ConsistentHashLbPolicyFluent<?> fluent){
            this(fluent, true);
    }
    public ConsistentHashLbPolicyBuilder(ConsistentHashLbPolicyFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ConsistentHashLbPolicy(), validationEnabled);
    }
    public ConsistentHashLbPolicyBuilder(ConsistentHashLbPolicyFluent<?> fluent,ConsistentHashLbPolicy instance){
            this(fluent, instance, true);
    }
    public ConsistentHashLbPolicyBuilder(ConsistentHashLbPolicyFluent<?> fluent,ConsistentHashLbPolicy instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withConsistentHash(instance.getConsistentHash()); 
            this.validationEnabled = validationEnabled; 
    }
    public ConsistentHashLbPolicyBuilder(ConsistentHashLbPolicy instance){
            this(instance,true);
    }
    public ConsistentHashLbPolicyBuilder(ConsistentHashLbPolicy instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withConsistentHash(instance.getConsistentHash()); 
            this.validationEnabled = validationEnabled; 
    }

    public ConsistentHashLbPolicy build(){
            ConsistentHashLbPolicy buildable = new ConsistentHashLbPolicy(fluent.getConsistentHash());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ConsistentHashLbPolicyBuilder that = (ConsistentHashLbPolicyBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
