
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.Duration;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "allowCredentials",
    "allowHeaders",
    "allowMethods",
    "allowOrigins",
    "allowOrigin",
    "exposeHeaders",
    "maxAge"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class CorsPolicy implements Serializable
{

    @JsonProperty("allowCredentials")
    private Boolean allowCredentials;
    /**
     * 
     */
    @JsonProperty("allowHeaders")
    @JsonPropertyDescription("")
    private List<String> allowHeaders = new ArrayList<String>();
    /**
     * 
     */
    @JsonProperty("allowMethods")
    @JsonPropertyDescription("")
    private List<String> allowMethods = new ArrayList<String>();
    /**
     * 
     */
    @JsonProperty("allowOrigins")
    @JsonPropertyDescription("")
    private List<StringMatch> allowOrigins = new ArrayList<StringMatch>();
    /**
     * 
     */
    @JsonProperty("allowOrigin")
    @JsonPropertyDescription("")
    private List<String> deprecatedAllowOrigin = new ArrayList<String>();
    /**
     * 
     */
    @JsonProperty("exposeHeaders")
    @JsonPropertyDescription("")
    private List<String> exposeHeaders = new ArrayList<String>();
    /**
     * 
     */
    @JsonProperty("maxAge")
    @JsonPropertyDescription("")
    private Duration maxAge;
    private final static long serialVersionUID = 5096311845837091607L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public CorsPolicy() {
    }

    /**
     * 
     * @param allowMethods
     * @param allowHeaders
     * @param exposeHeaders
     * @param maxAge
     * @param deprecatedAllowOrigin
     * @param allowCredentials
     * @param allowOrigins
     */
    public CorsPolicy(Boolean allowCredentials, List<String> allowHeaders, List<String> allowMethods, List<StringMatch> allowOrigins, List<String> deprecatedAllowOrigin, List<String> exposeHeaders, Duration maxAge) {
        super();
        this.allowCredentials = allowCredentials;
        this.allowHeaders = allowHeaders;
        this.allowMethods = allowMethods;
        this.allowOrigins = allowOrigins;
        this.deprecatedAllowOrigin = deprecatedAllowOrigin;
        this.exposeHeaders = exposeHeaders;
        this.maxAge = maxAge;
    }

    public Boolean getAllowCredentials() {
        return allowCredentials;
    }

    public void setAllowCredentials(Boolean allowCredentials) {
        this.allowCredentials = allowCredentials;
    }

    /**
     * 
     */
    public List<String> getAllowHeaders() {
        return allowHeaders;
    }

    /**
     * 
     */
    public void setAllowHeaders(List<String> allowHeaders) {
        this.allowHeaders = allowHeaders;
    }

    /**
     * 
     */
    public List<String> getAllowMethods() {
        return allowMethods;
    }

    /**
     * 
     */
    public void setAllowMethods(List<String> allowMethods) {
        this.allowMethods = allowMethods;
    }

    /**
     * 
     */
    public List<StringMatch> getAllowOrigins() {
        return allowOrigins;
    }

    /**
     * 
     */
    public void setAllowOrigins(List<StringMatch> allowOrigins) {
        this.allowOrigins = allowOrigins;
    }

    /**
     * 
     */
    public List<String> getDeprecatedAllowOrigin() {
        return deprecatedAllowOrigin;
    }

    /**
     * 
     */
    public void setDeprecatedAllowOrigin(List<String> deprecatedAllowOrigin) {
        this.deprecatedAllowOrigin = deprecatedAllowOrigin;
    }

    /**
     * 
     */
    public List<String> getExposeHeaders() {
        return exposeHeaders;
    }

    /**
     * 
     */
    public void setExposeHeaders(List<String> exposeHeaders) {
        this.exposeHeaders = exposeHeaders;
    }

    /**
     * 
     */
    public Duration getMaxAge() {
        return maxAge;
    }

    /**
     * 
     */
    public void setMaxAge(Duration maxAge) {
        this.maxAge = maxAge;
    }

}
