package me.snowdrop.istio.api.networking.v1alpha3;

import me.snowdrop.istio.api.DurationFluentImpl;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import com.fasterxml.jackson.databind.JsonSerializer;
import java.lang.String;
import com.fasterxml.jackson.databind.JsonDeserializer;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import java.util.List;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Boolean;
import java.lang.Override;
import com.fasterxml.jackson.core.JsonParser;
import me.snowdrop.istio.api.Duration;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import me.snowdrop.istio.api.DurationBuilder;

public class CorsPolicyFluentImpl<A extends CorsPolicyFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements CorsPolicyFluent<A>{

    private Boolean allowCredentials;
    private List<String> allowHeaders;
    private List<String> allowMethods;
    private List<StringMatchBuilder> allowOrigins;
    private List<String> deprecatedAllowOrigin;
    private List<String> exposeHeaders;
    private DurationBuilder maxAge;

    public CorsPolicyFluentImpl(){
    }
    public CorsPolicyFluentImpl(CorsPolicy instance){
            this.withAllowCredentials(instance.getAllowCredentials()); 
            this.withAllowHeaders(instance.getAllowHeaders()); 
            this.withAllowMethods(instance.getAllowMethods()); 
            this.withAllowOrigins(instance.getAllowOrigins()); 
            this.withDeprecatedAllowOrigin(instance.getDeprecatedAllowOrigin()); 
            this.withExposeHeaders(instance.getExposeHeaders()); 
            this.withMaxAge(instance.getMaxAge()); 
    }

    public Boolean isAllowCredentials(){
            return this.allowCredentials;
    }

    public A withAllowCredentials(Boolean allowCredentials){
            this.allowCredentials=allowCredentials; return (A) this;
    }

    public Boolean hasAllowCredentials(){
            return this.allowCredentials != null;
    }

    public A withNewAllowCredentials(String arg1){
            return (A)withAllowCredentials(new Boolean(arg1));
    }

    public A withNewAllowCredentials(boolean arg1){
            return (A)withAllowCredentials(new Boolean(arg1));
    }

    public A addToAllowHeaders(int index,String item){
            if (this.allowHeaders == null) {this.allowHeaders = new ArrayList<String>();}
            this.allowHeaders.add(index, item);
            return (A)this;
    }

    public A setToAllowHeaders(int index,String item){
            if (this.allowHeaders == null) {this.allowHeaders = new ArrayList<String>();}
            this.allowHeaders.set(index, item); return (A)this;
    }

    public A addToAllowHeaders(String... items){
            if (this.allowHeaders == null) {this.allowHeaders = new ArrayList<String>();}
            for (String item : items) {this.allowHeaders.add(item);} return (A)this;
    }

    public A addAllToAllowHeaders(Collection<String> items){
            if (this.allowHeaders == null) {this.allowHeaders = new ArrayList<String>();}
            for (String item : items) {this.allowHeaders.add(item);} return (A)this;
    }

    public A removeFromAllowHeaders(String... items){
            for (String item : items) {if (this.allowHeaders!= null){ this.allowHeaders.remove(item);}} return (A)this;
    }

    public A removeAllFromAllowHeaders(Collection<String> items){
            for (String item : items) {if (this.allowHeaders!= null){ this.allowHeaders.remove(item);}} return (A)this;
    }

    public List<String> getAllowHeaders(){
            return this.allowHeaders;
    }

    public String getAllowHeader(int index){
            return this.allowHeaders.get(index);
    }

    public String getFirstAllowHeader(){
            return this.allowHeaders.get(0);
    }

    public String getLastAllowHeader(){
            return this.allowHeaders.get(allowHeaders.size() - 1);
    }

    public String getMatchingAllowHeader(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: allowHeaders) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingAllowHeader(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: allowHeaders) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withAllowHeaders(List<String> allowHeaders){
            if (this.allowHeaders != null) { _visitables.get("allowHeaders").removeAll(this.allowHeaders);}
            if (allowHeaders != null) {this.allowHeaders = new ArrayList<String>(); for (String item : allowHeaders){this.addToAllowHeaders(item);}} else { this.allowHeaders = null;} return (A) this;
    }

    public A withAllowHeaders(String... allowHeaders){
            if (this.allowHeaders != null) {this.allowHeaders.clear();}
            if (allowHeaders != null) {for (String item :allowHeaders){ this.addToAllowHeaders(item);}} return (A) this;
    }

    public Boolean hasAllowHeaders(){
            return allowHeaders != null && !allowHeaders.isEmpty();
    }

    public A addNewAllowHeader(String arg1){
            return (A)addToAllowHeaders(new String(arg1));
    }

    public A addNewAllowHeader(StringBuilder arg1){
            return (A)addToAllowHeaders(new String(arg1));
    }

    public A addNewAllowHeader(StringBuffer arg1){
            return (A)addToAllowHeaders(new String(arg1));
    }

    public A addToAllowMethods(int index,String item){
            if (this.allowMethods == null) {this.allowMethods = new ArrayList<String>();}
            this.allowMethods.add(index, item);
            return (A)this;
    }

    public A setToAllowMethods(int index,String item){
            if (this.allowMethods == null) {this.allowMethods = new ArrayList<String>();}
            this.allowMethods.set(index, item); return (A)this;
    }

    public A addToAllowMethods(String... items){
            if (this.allowMethods == null) {this.allowMethods = new ArrayList<String>();}
            for (String item : items) {this.allowMethods.add(item);} return (A)this;
    }

    public A addAllToAllowMethods(Collection<String> items){
            if (this.allowMethods == null) {this.allowMethods = new ArrayList<String>();}
            for (String item : items) {this.allowMethods.add(item);} return (A)this;
    }

    public A removeFromAllowMethods(String... items){
            for (String item : items) {if (this.allowMethods!= null){ this.allowMethods.remove(item);}} return (A)this;
    }

    public A removeAllFromAllowMethods(Collection<String> items){
            for (String item : items) {if (this.allowMethods!= null){ this.allowMethods.remove(item);}} return (A)this;
    }

    public List<String> getAllowMethods(){
            return this.allowMethods;
    }

    public String getAllowMethod(int index){
            return this.allowMethods.get(index);
    }

    public String getFirstAllowMethod(){
            return this.allowMethods.get(0);
    }

    public String getLastAllowMethod(){
            return this.allowMethods.get(allowMethods.size() - 1);
    }

    public String getMatchingAllowMethod(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: allowMethods) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingAllowMethod(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: allowMethods) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withAllowMethods(List<String> allowMethods){
            if (this.allowMethods != null) { _visitables.get("allowMethods").removeAll(this.allowMethods);}
            if (allowMethods != null) {this.allowMethods = new ArrayList<String>(); for (String item : allowMethods){this.addToAllowMethods(item);}} else { this.allowMethods = null;} return (A) this;
    }

    public A withAllowMethods(String... allowMethods){
            if (this.allowMethods != null) {this.allowMethods.clear();}
            if (allowMethods != null) {for (String item :allowMethods){ this.addToAllowMethods(item);}} return (A) this;
    }

    public Boolean hasAllowMethods(){
            return allowMethods != null && !allowMethods.isEmpty();
    }

    public A addNewAllowMethod(String arg1){
            return (A)addToAllowMethods(new String(arg1));
    }

    public A addNewAllowMethod(StringBuilder arg1){
            return (A)addToAllowMethods(new String(arg1));
    }

    public A addNewAllowMethod(StringBuffer arg1){
            return (A)addToAllowMethods(new String(arg1));
    }

    public A addToAllowOrigins(int index,StringMatch item){
            if (this.allowOrigins == null) {this.allowOrigins = new ArrayList<StringMatchBuilder>();}
            StringMatchBuilder builder = new StringMatchBuilder(item);_visitables.get("allowOrigins").add(index >= 0 ? index : _visitables.get("allowOrigins").size(), builder);this.allowOrigins.add(index >= 0 ? index : allowOrigins.size(), builder); return (A)this;
    }

    public A setToAllowOrigins(int index,StringMatch item){
            if (this.allowOrigins == null) {this.allowOrigins = new ArrayList<StringMatchBuilder>();}
            StringMatchBuilder builder = new StringMatchBuilder(item);
            if (index < 0 || index >= _visitables.get("allowOrigins").size()) { _visitables.get("allowOrigins").add(builder); } else { _visitables.get("allowOrigins").set(index, builder);}
            if (index < 0 || index >= allowOrigins.size()) { allowOrigins.add(builder); } else { allowOrigins.set(index, builder);}
             return (A)this;
    }

    public A addToAllowOrigins(StringMatch... items){
            if (this.allowOrigins == null) {this.allowOrigins = new ArrayList<StringMatchBuilder>();}
            for (StringMatch item : items) {StringMatchBuilder builder = new StringMatchBuilder(item);_visitables.get("allowOrigins").add(builder);this.allowOrigins.add(builder);} return (A)this;
    }

    public A addAllToAllowOrigins(Collection<StringMatch> items){
            if (this.allowOrigins == null) {this.allowOrigins = new ArrayList<StringMatchBuilder>();}
            for (StringMatch item : items) {StringMatchBuilder builder = new StringMatchBuilder(item);_visitables.get("allowOrigins").add(builder);this.allowOrigins.add(builder);} return (A)this;
    }

    public A removeFromAllowOrigins(StringMatch... items){
            for (StringMatch item : items) {StringMatchBuilder builder = new StringMatchBuilder(item);_visitables.get("allowOrigins").remove(builder);if (this.allowOrigins != null) {this.allowOrigins.remove(builder);}} return (A)this;
    }

    public A removeAllFromAllowOrigins(Collection<StringMatch> items){
            for (StringMatch item : items) {StringMatchBuilder builder = new StringMatchBuilder(item);_visitables.get("allowOrigins").remove(builder);if (this.allowOrigins != null) {this.allowOrigins.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromAllowOrigins(io.fabric8.kubernetes.api.builder.Predicate<StringMatchBuilder> predicate){
            if (allowOrigins == null) return (A) this;
            final Iterator<StringMatchBuilder> each = allowOrigins.iterator();
            final List visitables = _visitables.get("allowOrigins");
            while (each.hasNext()) {
              StringMatchBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildAllowOrigins instead.
 * @return The buildable object.
 */
@Deprecated public List<StringMatch> getAllowOrigins(){
            return build(allowOrigins);
    }

    public List<StringMatch> buildAllowOrigins(){
            return build(allowOrigins);
    }

    public StringMatch buildAllowOrigin(int index){
            return this.allowOrigins.get(index).build();
    }

    public StringMatch buildFirstAllowOrigin(){
            return this.allowOrigins.get(0).build();
    }

    public StringMatch buildLastAllowOrigin(){
            return this.allowOrigins.get(allowOrigins.size() - 1).build();
    }

    public StringMatch buildMatchingAllowOrigin(io.fabric8.kubernetes.api.builder.Predicate<StringMatchBuilder> predicate){
            for (StringMatchBuilder item: allowOrigins) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingAllowOrigin(io.fabric8.kubernetes.api.builder.Predicate<StringMatchBuilder> predicate){
            for (StringMatchBuilder item: allowOrigins) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withAllowOrigins(List<StringMatch> allowOrigins){
            if (this.allowOrigins != null) { _visitables.get("allowOrigins").removeAll(this.allowOrigins);}
            if (allowOrigins != null) {this.allowOrigins = new ArrayList<StringMatchBuilder>(); for (StringMatch item : allowOrigins){this.addToAllowOrigins(item);}} else { this.allowOrigins = null;} return (A) this;
    }

    public A withAllowOrigins(StringMatch... allowOrigins){
            if (this.allowOrigins != null) {this.allowOrigins.clear();}
            if (allowOrigins != null) {for (StringMatch item :allowOrigins){ this.addToAllowOrigins(item);}} return (A) this;
    }

    public Boolean hasAllowOrigins(){
            return allowOrigins != null && !allowOrigins.isEmpty();
    }

    public CorsPolicyFluent.AllowOriginsNested<A> addNewAllowOrigin(){
            return new AllowOriginsNestedImpl();
    }

    public CorsPolicyFluent.AllowOriginsNested<A> addNewAllowOriginLike(StringMatch item){
            return new AllowOriginsNestedImpl(-1, item);
    }

    public CorsPolicyFluent.AllowOriginsNested<A> setNewAllowOriginLike(int index,StringMatch item){
            return new AllowOriginsNestedImpl(index, item);
    }

    public CorsPolicyFluent.AllowOriginsNested<A> editAllowOrigin(int index){
            if (allowOrigins.size() <= index) throw new RuntimeException("Can't edit allowOrigins. Index exceeds size.");
            return setNewAllowOriginLike(index, buildAllowOrigin(index));
    }

    public CorsPolicyFluent.AllowOriginsNested<A> editFirstAllowOrigin(){
            if (allowOrigins.size() == 0) throw new RuntimeException("Can't edit first allowOrigins. The list is empty.");
            return setNewAllowOriginLike(0, buildAllowOrigin(0));
    }

    public CorsPolicyFluent.AllowOriginsNested<A> editLastAllowOrigin(){
            int index = allowOrigins.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last allowOrigins. The list is empty.");
            return setNewAllowOriginLike(index, buildAllowOrigin(index));
    }

    public CorsPolicyFluent.AllowOriginsNested<A> editMatchingAllowOrigin(io.fabric8.kubernetes.api.builder.Predicate<StringMatchBuilder> predicate){
            int index = -1;
            for (int i=0;i<allowOrigins.size();i++) { 
            if (predicate.apply(allowOrigins.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching allowOrigins. No match found.");
            return setNewAllowOriginLike(index, buildAllowOrigin(index));
    }

    public A addToDeprecatedAllowOrigin(int index,String item){
            if (this.deprecatedAllowOrigin == null) {this.deprecatedAllowOrigin = new ArrayList<String>();}
            this.deprecatedAllowOrigin.add(index, item);
            return (A)this;
    }

    public A setToDeprecatedAllowOrigin(int index,String item){
            if (this.deprecatedAllowOrigin == null) {this.deprecatedAllowOrigin = new ArrayList<String>();}
            this.deprecatedAllowOrigin.set(index, item); return (A)this;
    }

    public A addToDeprecatedAllowOrigin(String... items){
            if (this.deprecatedAllowOrigin == null) {this.deprecatedAllowOrigin = new ArrayList<String>();}
            for (String item : items) {this.deprecatedAllowOrigin.add(item);} return (A)this;
    }

    public A addAllToDeprecatedAllowOrigin(Collection<String> items){
            if (this.deprecatedAllowOrigin == null) {this.deprecatedAllowOrigin = new ArrayList<String>();}
            for (String item : items) {this.deprecatedAllowOrigin.add(item);} return (A)this;
    }

    public A removeFromDeprecatedAllowOrigin(String... items){
            for (String item : items) {if (this.deprecatedAllowOrigin!= null){ this.deprecatedAllowOrigin.remove(item);}} return (A)this;
    }

    public A removeAllFromDeprecatedAllowOrigin(Collection<String> items){
            for (String item : items) {if (this.deprecatedAllowOrigin!= null){ this.deprecatedAllowOrigin.remove(item);}} return (A)this;
    }

    public List<String> getDeprecatedAllowOrigin(){
            return this.deprecatedAllowOrigin;
    }

    public String getDeprecatedAllowOrigin(int index){
            return this.deprecatedAllowOrigin.get(index);
    }

    public String getFirstDeprecatedAllowOrigin(){
            return this.deprecatedAllowOrigin.get(0);
    }

    public String getLastDeprecatedAllowOrigin(){
            return this.deprecatedAllowOrigin.get(deprecatedAllowOrigin.size() - 1);
    }

    public String getMatchingDeprecatedAllowOrigin(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: deprecatedAllowOrigin) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingDeprecatedAllowOrigin(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: deprecatedAllowOrigin) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withDeprecatedAllowOrigin(List<String> deprecatedAllowOrigin){
            if (this.deprecatedAllowOrigin != null) { _visitables.get("deprecatedAllowOrigin").removeAll(this.deprecatedAllowOrigin);}
            if (deprecatedAllowOrigin != null) {this.deprecatedAllowOrigin = new ArrayList<String>(); for (String item : deprecatedAllowOrigin){this.addToDeprecatedAllowOrigin(item);}} else { this.deprecatedAllowOrigin = null;} return (A) this;
    }

    public A withDeprecatedAllowOrigin(String... deprecatedAllowOrigin){
            if (this.deprecatedAllowOrigin != null) {this.deprecatedAllowOrigin.clear();}
            if (deprecatedAllowOrigin != null) {for (String item :deprecatedAllowOrigin){ this.addToDeprecatedAllowOrigin(item);}} return (A) this;
    }

    public Boolean hasDeprecatedAllowOrigin(){
            return deprecatedAllowOrigin != null && !deprecatedAllowOrigin.isEmpty();
    }

    public A addNewDeprecatedAllowOrigin(String arg1){
            return (A)addToDeprecatedAllowOrigin(new String(arg1));
    }

    public A addNewDeprecatedAllowOrigin(StringBuilder arg1){
            return (A)addToDeprecatedAllowOrigin(new String(arg1));
    }

    public A addNewDeprecatedAllowOrigin(StringBuffer arg1){
            return (A)addToDeprecatedAllowOrigin(new String(arg1));
    }

    public A addToExposeHeaders(int index,String item){
            if (this.exposeHeaders == null) {this.exposeHeaders = new ArrayList<String>();}
            this.exposeHeaders.add(index, item);
            return (A)this;
    }

    public A setToExposeHeaders(int index,String item){
            if (this.exposeHeaders == null) {this.exposeHeaders = new ArrayList<String>();}
            this.exposeHeaders.set(index, item); return (A)this;
    }

    public A addToExposeHeaders(String... items){
            if (this.exposeHeaders == null) {this.exposeHeaders = new ArrayList<String>();}
            for (String item : items) {this.exposeHeaders.add(item);} return (A)this;
    }

    public A addAllToExposeHeaders(Collection<String> items){
            if (this.exposeHeaders == null) {this.exposeHeaders = new ArrayList<String>();}
            for (String item : items) {this.exposeHeaders.add(item);} return (A)this;
    }

    public A removeFromExposeHeaders(String... items){
            for (String item : items) {if (this.exposeHeaders!= null){ this.exposeHeaders.remove(item);}} return (A)this;
    }

    public A removeAllFromExposeHeaders(Collection<String> items){
            for (String item : items) {if (this.exposeHeaders!= null){ this.exposeHeaders.remove(item);}} return (A)this;
    }

    public List<String> getExposeHeaders(){
            return this.exposeHeaders;
    }

    public String getExposeHeader(int index){
            return this.exposeHeaders.get(index);
    }

    public String getFirstExposeHeader(){
            return this.exposeHeaders.get(0);
    }

    public String getLastExposeHeader(){
            return this.exposeHeaders.get(exposeHeaders.size() - 1);
    }

    public String getMatchingExposeHeader(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: exposeHeaders) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingExposeHeader(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: exposeHeaders) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withExposeHeaders(List<String> exposeHeaders){
            if (this.exposeHeaders != null) { _visitables.get("exposeHeaders").removeAll(this.exposeHeaders);}
            if (exposeHeaders != null) {this.exposeHeaders = new ArrayList<String>(); for (String item : exposeHeaders){this.addToExposeHeaders(item);}} else { this.exposeHeaders = null;} return (A) this;
    }

    public A withExposeHeaders(String... exposeHeaders){
            if (this.exposeHeaders != null) {this.exposeHeaders.clear();}
            if (exposeHeaders != null) {for (String item :exposeHeaders){ this.addToExposeHeaders(item);}} return (A) this;
    }

    public Boolean hasExposeHeaders(){
            return exposeHeaders != null && !exposeHeaders.isEmpty();
    }

    public A addNewExposeHeader(String arg1){
            return (A)addToExposeHeaders(new String(arg1));
    }

    public A addNewExposeHeader(StringBuilder arg1){
            return (A)addToExposeHeaders(new String(arg1));
    }

    public A addNewExposeHeader(StringBuffer arg1){
            return (A)addToExposeHeaders(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildMaxAge instead.
 * @return The buildable object.
 */
@Deprecated public Duration getMaxAge(){
            return this.maxAge!=null?this.maxAge.build():null;
    }

    public Duration buildMaxAge(){
            return this.maxAge!=null?this.maxAge.build():null;
    }

    public A withMaxAge(Duration maxAge){
            _visitables.get("maxAge").remove(this.maxAge);
            if (maxAge!=null){ this.maxAge= new DurationBuilder(maxAge); _visitables.get("maxAge").add(this.maxAge);} return (A) this;
    }

    public Boolean hasMaxAge(){
            return this.maxAge != null;
    }

    public A withNewMaxAge(Integer nanos,Long seconds){
            return (A)withMaxAge(new Duration(nanos, seconds));
    }

    public CorsPolicyFluent.MaxAgeNested<A> withNewMaxAge(){
            return new MaxAgeNestedImpl();
    }

    public CorsPolicyFluent.MaxAgeNested<A> withNewMaxAgeLike(Duration item){
            return new MaxAgeNestedImpl(item);
    }

    public CorsPolicyFluent.MaxAgeNested<A> editMaxAge(){
            return withNewMaxAgeLike(getMaxAge());
    }

    public CorsPolicyFluent.MaxAgeNested<A> editOrNewMaxAge(){
            return withNewMaxAgeLike(getMaxAge() != null ? getMaxAge(): new DurationBuilder().build());
    }

    public CorsPolicyFluent.MaxAgeNested<A> editOrNewMaxAgeLike(Duration item){
            return withNewMaxAgeLike(getMaxAge() != null ? getMaxAge(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            CorsPolicyFluentImpl that = (CorsPolicyFluentImpl) o;
            if (allowCredentials != null ? !allowCredentials.equals(that.allowCredentials) :that.allowCredentials != null) return false;
            if (allowHeaders != null ? !allowHeaders.equals(that.allowHeaders) :that.allowHeaders != null) return false;
            if (allowMethods != null ? !allowMethods.equals(that.allowMethods) :that.allowMethods != null) return false;
            if (allowOrigins != null ? !allowOrigins.equals(that.allowOrigins) :that.allowOrigins != null) return false;
            if (deprecatedAllowOrigin != null ? !deprecatedAllowOrigin.equals(that.deprecatedAllowOrigin) :that.deprecatedAllowOrigin != null) return false;
            if (exposeHeaders != null ? !exposeHeaders.equals(that.exposeHeaders) :that.exposeHeaders != null) return false;
            if (maxAge != null ? !maxAge.equals(that.maxAge) :that.maxAge != null) return false;
            return true;
    }


    public class AllowOriginsNestedImpl<N> extends StringMatchFluentImpl<CorsPolicyFluent.AllowOriginsNested<N>> implements CorsPolicyFluent.AllowOriginsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final StringMatchBuilder builder;
        private final int index;
    
            AllowOriginsNestedImpl(int index,StringMatch item){
                    this.index = index;
                    this.builder = new StringMatchBuilder(this, item);
            }
            AllowOriginsNestedImpl(){
                    this.index = -1;
                    this.builder = new StringMatchBuilder(this);
            }
    
    public N and(){
            return (N) CorsPolicyFluentImpl.this.setToAllowOrigins(index,builder.build());
    }
    public N endAllowOrigin(){
            return and();
    }

}
    public class MaxAgeNestedImpl<N> extends DurationFluentImpl<CorsPolicyFluent.MaxAgeNested<N>> implements CorsPolicyFluent.MaxAgeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DurationBuilder builder;
    
            MaxAgeNestedImpl(Duration item){
                    this.builder = new DurationBuilder(this, item);
            }
            MaxAgeNestedImpl(){
                    this.builder = new DurationBuilder(this);
            }
    
    public N and(){
            return (N) CorsPolicyFluentImpl.this.withMaxAge(builder.build());
    }
    public N endMaxAge(){
            return and();
    }

}


}
