package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class DelayBuilder extends DelayFluentImpl<DelayBuilder> implements VisitableBuilder<Delay,DelayBuilder>{

    DelayFluent<?> fluent;
    Boolean validationEnabled;

    public DelayBuilder(){
            this(true);
    }
    public DelayBuilder(Boolean validationEnabled){
            this(new Delay(), validationEnabled);
    }
    public DelayBuilder(DelayFluent<?> fluent){
            this(fluent, true);
    }
    public DelayBuilder(DelayFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Delay(), validationEnabled);
    }
    public DelayBuilder(DelayFluent<?> fluent,Delay instance){
            this(fluent, instance, true);
    }
    public DelayBuilder(DelayFluent<?> fluent,Delay instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withHttpDelayType(instance.getHttpDelayType()); 
            fluent.withPercent(instance.getPercent()); 
            fluent.withPercentage(instance.getPercentage()); 
            this.validationEnabled = validationEnabled; 
    }
    public DelayBuilder(Delay instance){
            this(instance,true);
    }
    public DelayBuilder(Delay instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withHttpDelayType(instance.getHttpDelayType()); 
            this.withPercent(instance.getPercent()); 
            this.withPercentage(instance.getPercentage()); 
            this.validationEnabled = validationEnabled; 
    }

    public Delay build(){
            Delay buildable = new Delay(fluent.getHttpDelayType(),fluent.getPercent(),fluent.getPercentage());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DelayBuilder that = (DelayBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
