package me.snowdrop.istio.api.networking.v1alpha3;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import java.lang.Boolean;
import java.lang.Double;
import java.lang.Integer;
import java.lang.Object;

public class DelayFluentImpl<A extends DelayFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements DelayFluent<A>{

    private VisitableBuilder<? extends Delay.HttpDelayType,?> httpDelayType;
    private Integer percent;
    private PercentBuilder percentage;

    public DelayFluentImpl(){
    }
    public DelayFluentImpl(Delay instance){
            this.withHttpDelayType(instance.getHttpDelayType()); 
            this.withPercent(instance.getPercent()); 
            this.withPercentage(instance.getPercentage()); 
    }

    
/**
 * This method has been deprecated, please use method buildHttpDelayType instead.
 * @return The buildable object.
 */
@Deprecated public Delay.HttpDelayType getHttpDelayType(){
            return this.httpDelayType!=null?this.httpDelayType.build():null;
    }

    public Delay.HttpDelayType buildHttpDelayType(){
            return this.httpDelayType!=null?this.httpDelayType.build():null;
    }

    public A withHttpDelayType(Delay.HttpDelayType httpDelayType){
            if (httpDelayType instanceof FixedDelayHttpDelayType){ this.httpDelayType= new FixedDelayHttpDelayTypeBuilder((FixedDelayHttpDelayType)httpDelayType); _visitables.get("httpDelayType").add(this.httpDelayType);}
            if (httpDelayType instanceof ExponentialDelayHttpDelayType){ this.httpDelayType= new ExponentialDelayHttpDelayTypeBuilder((ExponentialDelayHttpDelayType)httpDelayType); _visitables.get("httpDelayType").add(this.httpDelayType);}
            return (A) this;
    }

    public Boolean hasHttpDelayType(){
            return this.httpDelayType != null;
    }

    public A withFixedDelayHttpType(FixedDelayHttpDelayType fixedDelayHttpType){
            _visitables.get("httpDelayType").remove(this.httpDelayType);
            if (fixedDelayHttpType!=null){ this.httpDelayType= new FixedDelayHttpDelayTypeBuilder(fixedDelayHttpType); _visitables.get("httpDelayType").add(this.httpDelayType);} return (A) this;
    }

    public DelayFluent.FixedDelayHttpTypeNested<A> withNewFixedDelayHttpType(){
            return new FixedDelayHttpTypeNestedImpl();
    }

    public DelayFluent.FixedDelayHttpTypeNested<A> withNewFixedDelayHttpTypeLike(FixedDelayHttpDelayType item){
            return new FixedDelayHttpTypeNestedImpl(item);
    }

    public A withExponentialDelayHttpType(ExponentialDelayHttpDelayType exponentialDelayHttpType){
            _visitables.get("httpDelayType").remove(this.httpDelayType);
            if (exponentialDelayHttpType!=null){ this.httpDelayType= new ExponentialDelayHttpDelayTypeBuilder(exponentialDelayHttpType); _visitables.get("httpDelayType").add(this.httpDelayType);} return (A) this;
    }

    public DelayFluent.ExponentialDelayHttpTypeNested<A> withNewExponentialDelayHttpType(){
            return new ExponentialDelayHttpTypeNestedImpl();
    }

    public DelayFluent.ExponentialDelayHttpTypeNested<A> withNewExponentialDelayHttpTypeLike(ExponentialDelayHttpDelayType item){
            return new ExponentialDelayHttpTypeNestedImpl(item);
    }

    public Integer getPercent(){
            return this.percent;
    }

    public A withPercent(Integer percent){
            this.percent=percent; return (A) this;
    }

    public Boolean hasPercent(){
            return this.percent != null;
    }

    
/**
 * This method has been deprecated, please use method buildPercentage instead.
 * @return The buildable object.
 */
@Deprecated public Percent getPercentage(){
            return this.percentage!=null?this.percentage.build():null;
    }

    public Percent buildPercentage(){
            return this.percentage!=null?this.percentage.build():null;
    }

    public A withPercentage(Percent percentage){
            _visitables.get("percentage").remove(this.percentage);
            if (percentage!=null){ this.percentage= new PercentBuilder(percentage); _visitables.get("percentage").add(this.percentage);} return (A) this;
    }

    public Boolean hasPercentage(){
            return this.percentage != null;
    }

    public A withNewPercentage(Double value){
            return (A)withPercentage(new Percent(value));
    }

    public DelayFluent.PercentageNested<A> withNewPercentage(){
            return new PercentageNestedImpl();
    }

    public DelayFluent.PercentageNested<A> withNewPercentageLike(Percent item){
            return new PercentageNestedImpl(item);
    }

    public DelayFluent.PercentageNested<A> editPercentage(){
            return withNewPercentageLike(getPercentage());
    }

    public DelayFluent.PercentageNested<A> editOrNewPercentage(){
            return withNewPercentageLike(getPercentage() != null ? getPercentage(): new PercentBuilder().build());
    }

    public DelayFluent.PercentageNested<A> editOrNewPercentageLike(Percent item){
            return withNewPercentageLike(getPercentage() != null ? getPercentage(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            DelayFluentImpl that = (DelayFluentImpl) o;
            if (httpDelayType != null ? !httpDelayType.equals(that.httpDelayType) :that.httpDelayType != null) return false;
            if (percent != null ? !percent.equals(that.percent) :that.percent != null) return false;
            if (percentage != null ? !percentage.equals(that.percentage) :that.percentage != null) return false;
            return true;
    }


    public class FixedDelayHttpTypeNestedImpl<N> extends FixedDelayHttpDelayTypeFluentImpl<DelayFluent.FixedDelayHttpTypeNested<N>> implements DelayFluent.FixedDelayHttpTypeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final FixedDelayHttpDelayTypeBuilder builder;
    
            FixedDelayHttpTypeNestedImpl(FixedDelayHttpDelayType item){
                    this.builder = new FixedDelayHttpDelayTypeBuilder(this, item);
            }
            FixedDelayHttpTypeNestedImpl(){
                    this.builder = new FixedDelayHttpDelayTypeBuilder(this);
            }
    
    public N and(){
            return (N) DelayFluentImpl.this.withHttpDelayType(builder.build());
    }
    public N endFixedDelayHttpType(){
            return and();
    }

}
    public class ExponentialDelayHttpTypeNestedImpl<N> extends ExponentialDelayHttpDelayTypeFluentImpl<DelayFluent.ExponentialDelayHttpTypeNested<N>> implements DelayFluent.ExponentialDelayHttpTypeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ExponentialDelayHttpDelayTypeBuilder builder;
    
            ExponentialDelayHttpTypeNestedImpl(ExponentialDelayHttpDelayType item){
                    this.builder = new ExponentialDelayHttpDelayTypeBuilder(this, item);
            }
            ExponentialDelayHttpTypeNestedImpl(){
                    this.builder = new ExponentialDelayHttpDelayTypeBuilder(this);
            }
    
    public N and(){
            return (N) DelayFluentImpl.this.withHttpDelayType(builder.build());
    }
    public N endExponentialDelayHttpType(){
            return and();
    }

}
    public class PercentageNestedImpl<N> extends PercentFluentImpl<DelayFluent.PercentageNested<N>> implements DelayFluent.PercentageNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PercentBuilder builder;
    
            PercentageNestedImpl(Percent item){
                    this.builder = new PercentBuilder(this, item);
            }
            PercentageNestedImpl(){
                    this.builder = new PercentBuilder(this);
            }
    
    public N and(){
            return (N) DelayFluentImpl.this.withPercentage(builder.build());
    }
    public N endPercentage(){
            return and();
    }

}


}
