package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class DelegateBuilder extends DelegateFluentImpl<DelegateBuilder> implements VisitableBuilder<Delegate,DelegateBuilder>{

    DelegateFluent<?> fluent;
    Boolean validationEnabled;

    public DelegateBuilder(){
            this(true);
    }
    public DelegateBuilder(Boolean validationEnabled){
            this(new Delegate(), validationEnabled);
    }
    public DelegateBuilder(DelegateFluent<?> fluent){
            this(fluent, true);
    }
    public DelegateBuilder(DelegateFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Delegate(), validationEnabled);
    }
    public DelegateBuilder(DelegateFluent<?> fluent,Delegate instance){
            this(fluent, instance, true);
    }
    public DelegateBuilder(DelegateFluent<?> fluent,Delegate instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withName(instance.getName()); 
            fluent.withNamespace(instance.getNamespace()); 
            this.validationEnabled = validationEnabled; 
    }
    public DelegateBuilder(Delegate instance){
            this(instance,true);
    }
    public DelegateBuilder(Delegate instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withName(instance.getName()); 
            this.withNamespace(instance.getNamespace()); 
            this.validationEnabled = validationEnabled; 
    }

    public Delegate build(){
            Delegate buildable = new Delegate(fluent.getName(),fluent.getNamespace());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DelegateBuilder that = (DelegateBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
